// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This entity describes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public class JobTemplate private constructor(builder: Builder) {
    /**
     * The ARN of the job template.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time when the job template was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The user who created the job template.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The error message in case the decryption of job template fails.
     */
    public val decryptionError: kotlin.String? = builder.decryptionError
    /**
     * The ID of the job template.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The job template data which holds values of StartJobRun API request.
     */
    public val jobTemplateData: aws.sdk.kotlin.services.emrcontainers.model.JobTemplateData? = builder.jobTemplateData
    /**
     * The KMS key ARN used to encrypt the job template.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the job template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags assigned to the job template.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrcontainers.model.JobTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobTemplate(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("decryptionError=$decryptionError,")
        append("id=$id,")
        append("jobTemplateData=$jobTemplateData,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (decryptionError?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (jobTemplateData?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobTemplate

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (decryptionError != other.decryptionError) return false
        if (id != other.id) return false
        if (jobTemplateData != other.jobTemplateData) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrcontainers.model.JobTemplate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the job template.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time when the job template was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the job template.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The error message in case the decryption of job template fails.
         */
        public var decryptionError: kotlin.String? = null
        /**
         * The ID of the job template.
         */
        public var id: kotlin.String? = null
        /**
         * The job template data which holds values of StartJobRun API request.
         */
        public var jobTemplateData: aws.sdk.kotlin.services.emrcontainers.model.JobTemplateData? = null
        /**
         * The KMS key ARN used to encrypt the job template.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the job template.
         */
        public var name: kotlin.String? = null
        /**
         * The tags assigned to the job template.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrcontainers.model.JobTemplate) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.decryptionError = x.decryptionError
            this.id = x.id
            this.jobTemplateData = x.jobTemplateData
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrcontainers.model.JobTemplate = JobTemplate(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrcontainers.model.JobTemplateData] inside the given [block]
         */
        public fun jobTemplateData(block: aws.sdk.kotlin.services.emrcontainers.model.JobTemplateData.Builder.() -> kotlin.Unit) {
            this.jobTemplateData = aws.sdk.kotlin.services.emrcontainers.model.JobTemplateData.invoke(block)
        }
    }
}
