// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.endpoints

import aws.sdk.kotlin.services.emrcontainers.endpoints.internal.partition
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.http.endpoints.functions.parseUrl

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null
            ) {
                run {
                    val url = parseUrl(params.endpoint)
                    if (
                        url != null &&
                        params.endpoint != null
                    ) {
                        if (
                            params.useFips == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
                        }
                        return Endpoint(
                            Url.parse(params.endpoint),
                        )
                    }
                }
                if (
                    params.useFips == true &&
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS &&
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://emr-containers-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                }
                if (
                    params.useFips == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS
                    ) {
                        return Endpoint(
                            Url.parse("https://emr-containers-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                }
                if (
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://emr-containers.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                }
                return Endpoint(
                    Url.parse("https://emr-containers.${params.region}.${partitionResult?.dnsSuffix}"),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
