// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.emrcontainers.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.emrcontainers.endpoints.EndpointProvider
import aws.sdk.kotlin.services.emrcontainers.model.*
import aws.sdk.kotlin.services.emrcontainers.model.CancelJobRunRequest
import aws.sdk.kotlin.services.emrcontainers.model.CancelJobRunResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateJobTemplateRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateJobTemplateResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateManagedEndpointRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateManagedEndpointResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateVirtualClusterRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateVirtualClusterResponse
import aws.sdk.kotlin.services.emrcontainers.model.DeleteJobTemplateRequest
import aws.sdk.kotlin.services.emrcontainers.model.DeleteJobTemplateResponse
import aws.sdk.kotlin.services.emrcontainers.model.DeleteManagedEndpointRequest
import aws.sdk.kotlin.services.emrcontainers.model.DeleteManagedEndpointResponse
import aws.sdk.kotlin.services.emrcontainers.model.DeleteVirtualClusterRequest
import aws.sdk.kotlin.services.emrcontainers.model.DeleteVirtualClusterResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobRunRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobRunResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobTemplateRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobTemplateResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeManagedEndpointRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeManagedEndpointResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeVirtualClusterRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeVirtualClusterResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListJobTemplatesRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListJobTemplatesResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListVirtualClustersRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListVirtualClustersResponse
import aws.sdk.kotlin.services.emrcontainers.model.StartJobRunRequest
import aws.sdk.kotlin.services.emrcontainers.model.StartJobRunResponse
import aws.sdk.kotlin.services.emrcontainers.model.TagResourceRequest
import aws.sdk.kotlin.services.emrcontainers.model.TagResourceResponse
import aws.sdk.kotlin.services.emrcontainers.model.UntagResourceRequest
import aws.sdk.kotlin.services.emrcontainers.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * Amazon EMR on EKS provides a deployment option for Amazon EMR that allows you to run open-source big data frameworks on Amazon Elastic Kubernetes Service (Amazon EKS). With this deployment option, you can focus on running analytics workloads while Amazon EMR on EKS builds, configures, and manages containers for open-source applications. For more information about Amazon EMR on EKS concepts and tasks, see [What is Amazon EMR on EKS](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/emr-eks.html).
 *
 * *Amazon EMR containers* is the API name for Amazon EMR on EKS. The `emr-containers` prefix is used in the following scenarios:
 * + It is the prefix in the CLI commands for Amazon EMR on EKS. For example, `aws emr-containers start-job-run`.
 * + It is the prefix before IAM policy actions for Amazon EMR on EKS. For example, `"Action": [ "emr-containers:StartJobRun"]`. For more information, see [Policy actions for Amazon EMR on EKS](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-actions).
 * + It is the prefix used in Amazon EMR on EKS service endpoints. For example, `emr-containers.us-east-2.amazonaws.com`. For more information, see [Amazon EMR on EKS Service Endpoints](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/service-quotas.html#service-endpoints).
 */
public interface EmrContainersClient : SdkClient {

    override val serviceName: String
        get() = "EMR containers"
    /**
     * EmrContainersClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): EmrContainersClient {
            val config = Config.Builder().apply(block).build()
            return DefaultEmrContainersClient(config)
        }

        public operator fun invoke(config: Config): EmrContainersClient = DefaultEmrContainersClient(config)

        /**
         * Construct a [EmrContainersClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): EmrContainersClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultEmrContainersClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "EMR containers")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun cancelJobRun(input: CancelJobRunRequest): CancelJobRunResponse

    /**
     * Creates a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse

    /**
     * Creates a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun createManagedEndpoint(input: CreateManagedEndpointRequest): CreateManagedEndpointResponse

    /**
     * Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun createVirtualCluster(input: CreateVirtualClusterRequest): CreateVirtualClusterResponse

    /**
     * Deletes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse

    /**
     * Deletes a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun deleteManagedEndpoint(input: DeleteManagedEndpointRequest): DeleteManagedEndpointResponse

    /**
     * Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun deleteVirtualCluster(input: DeleteVirtualClusterRequest): DeleteVirtualClusterResponse

    /**
     * Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun describeJobRun(input: DescribeJobRunRequest): DescribeJobRunResponse

    /**
     * Displays detailed information about a specified job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun describeJobTemplate(input: DescribeJobTemplateRequest): DescribeJobTemplateResponse

    /**
     * Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun describeManagedEndpoint(input: DescribeManagedEndpointRequest): DescribeManagedEndpointResponse

    /**
     * Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun describeVirtualCluster(input: DescribeVirtualClusterRequest): DescribeVirtualClusterResponse

    /**
     * Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun listJobRuns(input: ListJobRunsRequest): ListJobRunsResponse

    /**
     * Lists job templates based on a set of parameters. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun listJobTemplates(input: ListJobTemplatesRequest = ListJobTemplatesRequest {}): ListJobTemplatesResponse

    /**
     * Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun listManagedEndpoints(input: ListManagedEndpointsRequest): ListManagedEndpointsResponse

    /**
     * Lists the tags assigned to the resources.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun listVirtualClusters(input: ListVirtualClustersRequest = ListVirtualClustersRequest {}): ListVirtualClustersResponse

    /**
     * Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun startJobRun(input: StartJobRunRequest): StartJobRunResponse

    /**
     * Assigns tags to resources. A tag is a label that you assign to an AWS resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your AWS resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster's owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from resources.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.cancelJobRun(crossinline block: CancelJobRunRequest.Builder.() -> Unit): CancelJobRunResponse = cancelJobRun(CancelJobRunRequest.Builder().apply(block).build())

/**
 * Creates a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.createJobTemplate(crossinline block: CreateJobTemplateRequest.Builder.() -> Unit): CreateJobTemplateResponse = createJobTemplate(CreateJobTemplateRequest.Builder().apply(block).build())

/**
 * Creates a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.createManagedEndpoint(crossinline block: CreateManagedEndpointRequest.Builder.() -> Unit): CreateManagedEndpointResponse = createManagedEndpoint(CreateManagedEndpointRequest.Builder().apply(block).build())

/**
 * Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.createVirtualCluster(crossinline block: CreateVirtualClusterRequest.Builder.() -> Unit): CreateVirtualClusterResponse = createVirtualCluster(CreateVirtualClusterRequest.Builder().apply(block).build())

/**
 * Deletes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.deleteJobTemplate(crossinline block: DeleteJobTemplateRequest.Builder.() -> Unit): DeleteJobTemplateResponse = deleteJobTemplate(DeleteJobTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.deleteManagedEndpoint(crossinline block: DeleteManagedEndpointRequest.Builder.() -> Unit): DeleteManagedEndpointResponse = deleteManagedEndpoint(DeleteManagedEndpointRequest.Builder().apply(block).build())

/**
 * Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.deleteVirtualCluster(crossinline block: DeleteVirtualClusterRequest.Builder.() -> Unit): DeleteVirtualClusterResponse = deleteVirtualCluster(DeleteVirtualClusterRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.describeJobRun(crossinline block: DescribeJobRunRequest.Builder.() -> Unit): DescribeJobRunResponse = describeJobRun(DescribeJobRunRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a specified job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.describeJobTemplate(crossinline block: DescribeJobTemplateRequest.Builder.() -> Unit): DescribeJobTemplateResponse = describeJobTemplate(DescribeJobTemplateRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.describeManagedEndpoint(crossinline block: DescribeManagedEndpointRequest.Builder.() -> Unit): DescribeManagedEndpointResponse = describeManagedEndpoint(DescribeManagedEndpointRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.describeVirtualCluster(crossinline block: DescribeVirtualClusterRequest.Builder.() -> Unit): DescribeVirtualClusterResponse = describeVirtualCluster(DescribeVirtualClusterRequest.Builder().apply(block).build())

/**
 * Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.listJobRuns(crossinline block: ListJobRunsRequest.Builder.() -> Unit): ListJobRunsResponse = listJobRuns(ListJobRunsRequest.Builder().apply(block).build())

/**
 * Lists job templates based on a set of parameters. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.listJobTemplates(crossinline block: ListJobTemplatesRequest.Builder.() -> Unit): ListJobTemplatesResponse = listJobTemplates(ListJobTemplatesRequest.Builder().apply(block).build())

/**
 * Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.listManagedEndpoints(crossinline block: ListManagedEndpointsRequest.Builder.() -> Unit): ListManagedEndpointsResponse = listManagedEndpoints(ListManagedEndpointsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to the resources.
 */
public suspend inline fun EmrContainersClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.listVirtualClusters(crossinline block: ListVirtualClustersRequest.Builder.() -> Unit): ListVirtualClustersResponse = listVirtualClusters(ListVirtualClustersRequest.Builder().apply(block).build())

/**
 * Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.startJobRun(crossinline block: StartJobRunRequest.Builder.() -> Unit): StartJobRunResponse = startJobRun(StartJobRunRequest.Builder().apply(block).build())

/**
 * Assigns tags to resources. A tag is a label that you assign to an AWS resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your AWS resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster's owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.
 */
public suspend inline fun EmrContainersClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from resources.
 */
public suspend inline fun EmrContainersClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
