// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * This represents a step in a cluster.
 */
public class Step private constructor(builder: Builder) {
    /**
     * The action to take when the cluster step fails. Possible values are `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`. `TERMINATE_JOB_FLOW` is provided for backward compatibility. We recommend using `TERMINATE_CLUSTER` instead.
     *
     * If a cluster's `StepConcurrencyLevel` is greater than `1`, do not use `AddJobFlowSteps` to submit a step with this parameter set to `CANCEL_AND_WAIT` or `TERMINATE_CLUSTER`. The step is not submitted and the action fails with a message that the `ActionOnFailure` setting is not valid.
     *
     * If you change a cluster's `StepConcurrencyLevel` to be greater than 1 while a step is running, the `ActionOnFailure` parameter may not behave as you expect. In this case, for a step that fails with this parameter set to `CANCEL_AND_WAIT`, pending steps and the running step are not canceled; for a step that fails with this parameter set to `TERMINATE_CLUSTER`, the cluster does not terminate.
     */
    public val actionOnFailure: aws.sdk.kotlin.services.emr.model.ActionOnFailure? = builder.actionOnFailure
    /**
     * The Hadoop job configuration of the cluster step.
     */
    public val config: aws.sdk.kotlin.services.emr.model.HadoopStepConfig? = builder.config
    /**
     * The Amazon Resource Name (ARN) of the runtime role for a step on the cluster. The runtime role can be a cross-account IAM role. The runtime role ARN is a combination of account ID, role name, and role type using the following format: `arn:partition:service:region:account:resource`.
     *
     * For example, `arn:aws:iam::1234567890:role/ReadOnly` is a correctly formatted runtime role ARN.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The identifier of the cluster step.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the cluster step.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current execution status details of the cluster step.
     */
    public val status: aws.sdk.kotlin.services.emr.model.StepStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Step = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Step(")
        append("actionOnFailure=$actionOnFailure,")
        append("config=$config,")
        append("executionRoleArn=$executionRoleArn,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionOnFailure?.hashCode() ?: 0
        result = 31 * result + (config?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Step

        if (actionOnFailure != other.actionOnFailure) return false
        if (config != other.config) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Step = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to take when the cluster step fails. Possible values are `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`. `TERMINATE_JOB_FLOW` is provided for backward compatibility. We recommend using `TERMINATE_CLUSTER` instead.
         *
         * If a cluster's `StepConcurrencyLevel` is greater than `1`, do not use `AddJobFlowSteps` to submit a step with this parameter set to `CANCEL_AND_WAIT` or `TERMINATE_CLUSTER`. The step is not submitted and the action fails with a message that the `ActionOnFailure` setting is not valid.
         *
         * If you change a cluster's `StepConcurrencyLevel` to be greater than 1 while a step is running, the `ActionOnFailure` parameter may not behave as you expect. In this case, for a step that fails with this parameter set to `CANCEL_AND_WAIT`, pending steps and the running step are not canceled; for a step that fails with this parameter set to `TERMINATE_CLUSTER`, the cluster does not terminate.
         */
        public var actionOnFailure: aws.sdk.kotlin.services.emr.model.ActionOnFailure? = null
        /**
         * The Hadoop job configuration of the cluster step.
         */
        public var config: aws.sdk.kotlin.services.emr.model.HadoopStepConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the runtime role for a step on the cluster. The runtime role can be a cross-account IAM role. The runtime role ARN is a combination of account ID, role name, and role type using the following format: `arn:partition:service:region:account:resource`.
         *
         * For example, `arn:aws:iam::1234567890:role/ReadOnly` is a correctly formatted runtime role ARN.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The identifier of the cluster step.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the cluster step.
         */
        public var name: kotlin.String? = null
        /**
         * The current execution status details of the cluster step.
         */
        public var status: aws.sdk.kotlin.services.emr.model.StepStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Step) : this() {
            this.actionOnFailure = x.actionOnFailure
            this.config = x.config
            this.executionRoleArn = x.executionRoleArn
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Step = Step(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.HadoopStepConfig] inside the given [block]
         */
        public fun config(block: aws.sdk.kotlin.services.emr.model.HadoopStepConfig.Builder.() -> kotlin.Unit) {
            this.config = aws.sdk.kotlin.services.emr.model.HadoopStepConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.StepStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.emr.model.StepStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.StepStatus.invoke(block)
        }
    }
}
