// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * A description of the Amazon EC2 instance on which the cluster (job flow) runs. A valid JobFlowInstancesConfig must contain either InstanceGroups or InstanceFleets. They cannot be used together. You may also have MasterInstanceType, SlaveInstanceType, and InstanceCount (all three must be present), but we don't recommend this configuration.
 */
public class JobFlowInstancesConfig private constructor(builder: Builder) {
    /**
     * A list of additional Amazon EC2 security group IDs for the master node.
     */
    public val additionalMasterSecurityGroups: List<String>? = builder.additionalMasterSecurityGroups
    /**
     * A list of additional Amazon EC2 security group IDs for the core and task nodes.
     */
    public val additionalSlaveSecurityGroups: List<String>? = builder.additionalSlaveSecurityGroups
    /**
     * The name of the EC2 key pair that can be used to connect to the master node using SSH as the user called "hadoop."
     */
    public val ec2KeyName: kotlin.String? = builder.ec2KeyName
    /**
     * Applies to clusters that use the uniform instance group configuration. To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this value and your account supports EC2-Classic, the cluster launches in EC2-Classic.
     */
    public val ec2SubnetId: kotlin.String? = builder.ec2SubnetId
    /**
     * Applies to clusters that use the instance fleet configuration. When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances in the optimal subnet.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     */
    public val ec2SubnetIds: List<String>? = builder.ec2SubnetIds
    /**
     * The identifier of the Amazon EC2 security group for the master node. If you specify `EmrManagedMasterSecurityGroup`, you must also specify `EmrManagedSlaveSecurityGroup`.
     */
    public val emrManagedMasterSecurityGroup: kotlin.String? = builder.emrManagedMasterSecurityGroup
    /**
     * The identifier of the Amazon EC2 security group for the core and task nodes. If you specify `EmrManagedSlaveSecurityGroup`, you must also specify `EmrManagedMasterSecurityGroup`.
     */
    public val emrManagedSlaveSecurityGroup: kotlin.String? = builder.emrManagedSlaveSecurityGroup
    /**
     * Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained), "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this value, the default of 0.18 is used, unless the `AmiVersion` parameter is set in the RunJobFlow call, in which case the default version of Hadoop for that AMI version is used.
     */
    public val hadoopVersion: kotlin.String? = builder.hadoopVersion
    /**
     * The number of EC2 instances in the cluster.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     *
     * Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
     */
    public val instanceFleets: List<InstanceFleetConfig>? = builder.instanceFleets
    /**
     * Configuration for the instance groups in a cluster.
     */
    public val instanceGroups: List<InstanceGroupConfig>? = builder.instanceGroups
    /**
     * Specifies whether the cluster should remain available after completing all steps. Defaults to `true`. For more information about configuring cluster termination, see [Control Cluster Termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html) in the *EMR Management Guide*.
     */
    public val keepJobFlowAliveWhenNoSteps: kotlin.Boolean = builder.keepJobFlowAliveWhenNoSteps
    /**
     * The EC2 instance type of the master node.
     */
    public val masterInstanceType: kotlin.String? = builder.masterInstanceType
    /**
     * The Availability Zone in which the cluster runs.
     */
    public val placement: aws.sdk.kotlin.services.emr.model.PlacementType? = builder.placement
    /**
     * The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
     */
    public val serviceAccessSecurityGroup: kotlin.String? = builder.serviceAccessSecurityGroup
    /**
     * The EC2 instance type of the core and task nodes.
     */
    public val slaveInstanceType: kotlin.String? = builder.slaveInstanceType
    /**
     * Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
     */
    public val terminationProtected: kotlin.Boolean = builder.terminationProtected

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobFlowInstancesConfig(")
        append("additionalMasterSecurityGroups=$additionalMasterSecurityGroups,")
        append("additionalSlaveSecurityGroups=$additionalSlaveSecurityGroups,")
        append("ec2KeyName=$ec2KeyName,")
        append("ec2SubnetId=$ec2SubnetId,")
        append("ec2SubnetIds=$ec2SubnetIds,")
        append("emrManagedMasterSecurityGroup=$emrManagedMasterSecurityGroup,")
        append("emrManagedSlaveSecurityGroup=$emrManagedSlaveSecurityGroup,")
        append("hadoopVersion=$hadoopVersion,")
        append("instanceCount=$instanceCount,")
        append("instanceFleets=$instanceFleets,")
        append("instanceGroups=$instanceGroups,")
        append("keepJobFlowAliveWhenNoSteps=$keepJobFlowAliveWhenNoSteps,")
        append("masterInstanceType=$masterInstanceType,")
        append("placement=$placement,")
        append("serviceAccessSecurityGroup=$serviceAccessSecurityGroup,")
        append("slaveInstanceType=$slaveInstanceType,")
        append("terminationProtected=$terminationProtected")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalMasterSecurityGroups?.hashCode() ?: 0
        result = 31 * result + (additionalSlaveSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (ec2KeyName?.hashCode() ?: 0)
        result = 31 * result + (ec2SubnetId?.hashCode() ?: 0)
        result = 31 * result + (ec2SubnetIds?.hashCode() ?: 0)
        result = 31 * result + (emrManagedMasterSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (emrManagedSlaveSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (hadoopVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceFleets?.hashCode() ?: 0)
        result = 31 * result + (instanceGroups?.hashCode() ?: 0)
        result = 31 * result + (keepJobFlowAliveWhenNoSteps.hashCode())
        result = 31 * result + (masterInstanceType?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (slaveInstanceType?.hashCode() ?: 0)
        result = 31 * result + (terminationProtected.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobFlowInstancesConfig

        if (additionalMasterSecurityGroups != other.additionalMasterSecurityGroups) return false
        if (additionalSlaveSecurityGroups != other.additionalSlaveSecurityGroups) return false
        if (ec2KeyName != other.ec2KeyName) return false
        if (ec2SubnetId != other.ec2SubnetId) return false
        if (ec2SubnetIds != other.ec2SubnetIds) return false
        if (emrManagedMasterSecurityGroup != other.emrManagedMasterSecurityGroup) return false
        if (emrManagedSlaveSecurityGroup != other.emrManagedSlaveSecurityGroup) return false
        if (hadoopVersion != other.hadoopVersion) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceFleets != other.instanceFleets) return false
        if (instanceGroups != other.instanceGroups) return false
        if (keepJobFlowAliveWhenNoSteps != other.keepJobFlowAliveWhenNoSteps) return false
        if (masterInstanceType != other.masterInstanceType) return false
        if (placement != other.placement) return false
        if (serviceAccessSecurityGroup != other.serviceAccessSecurityGroup) return false
        if (slaveInstanceType != other.slaveInstanceType) return false
        if (terminationProtected != other.terminationProtected) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of additional Amazon EC2 security group IDs for the master node.
         */
        public var additionalMasterSecurityGroups: List<String>? = null
        /**
         * A list of additional Amazon EC2 security group IDs for the core and task nodes.
         */
        public var additionalSlaveSecurityGroups: List<String>? = null
        /**
         * The name of the EC2 key pair that can be used to connect to the master node using SSH as the user called "hadoop."
         */
        public var ec2KeyName: kotlin.String? = null
        /**
         * Applies to clusters that use the uniform instance group configuration. To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this value and your account supports EC2-Classic, the cluster launches in EC2-Classic.
         */
        public var ec2SubnetId: kotlin.String? = null
        /**
         * Applies to clusters that use the instance fleet configuration. When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances in the optimal subnet.
         *
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         */
        public var ec2SubnetIds: List<String>? = null
        /**
         * The identifier of the Amazon EC2 security group for the master node. If you specify `EmrManagedMasterSecurityGroup`, you must also specify `EmrManagedSlaveSecurityGroup`.
         */
        public var emrManagedMasterSecurityGroup: kotlin.String? = null
        /**
         * The identifier of the Amazon EC2 security group for the core and task nodes. If you specify `EmrManagedSlaveSecurityGroup`, you must also specify `EmrManagedMasterSecurityGroup`.
         */
        public var emrManagedSlaveSecurityGroup: kotlin.String? = null
        /**
         * Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained), "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this value, the default of 0.18 is used, unless the `AmiVersion` parameter is set in the RunJobFlow call, in which case the default version of Hadoop for that AMI version is used.
         */
        public var hadoopVersion: kotlin.String? = null
        /**
         * The number of EC2 instances in the cluster.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         *
         * Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
         */
        public var instanceFleets: List<InstanceFleetConfig>? = null
        /**
         * Configuration for the instance groups in a cluster.
         */
        public var instanceGroups: List<InstanceGroupConfig>? = null
        /**
         * Specifies whether the cluster should remain available after completing all steps. Defaults to `true`. For more information about configuring cluster termination, see [Control Cluster Termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html) in the *EMR Management Guide*.
         */
        public var keepJobFlowAliveWhenNoSteps: kotlin.Boolean = false
        /**
         * The EC2 instance type of the master node.
         */
        public var masterInstanceType: kotlin.String? = null
        /**
         * The Availability Zone in which the cluster runs.
         */
        public var placement: aws.sdk.kotlin.services.emr.model.PlacementType? = null
        /**
         * The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
         */
        public var serviceAccessSecurityGroup: kotlin.String? = null
        /**
         * The EC2 instance type of the core and task nodes.
         */
        public var slaveInstanceType: kotlin.String? = null
        /**
         * Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
         */
        public var terminationProtected: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig) : this() {
            this.additionalMasterSecurityGroups = x.additionalMasterSecurityGroups
            this.additionalSlaveSecurityGroups = x.additionalSlaveSecurityGroups
            this.ec2KeyName = x.ec2KeyName
            this.ec2SubnetId = x.ec2SubnetId
            this.ec2SubnetIds = x.ec2SubnetIds
            this.emrManagedMasterSecurityGroup = x.emrManagedMasterSecurityGroup
            this.emrManagedSlaveSecurityGroup = x.emrManagedSlaveSecurityGroup
            this.hadoopVersion = x.hadoopVersion
            this.instanceCount = x.instanceCount
            this.instanceFleets = x.instanceFleets
            this.instanceGroups = x.instanceGroups
            this.keepJobFlowAliveWhenNoSteps = x.keepJobFlowAliveWhenNoSteps
            this.masterInstanceType = x.masterInstanceType
            this.placement = x.placement
            this.serviceAccessSecurityGroup = x.serviceAccessSecurityGroup
            this.slaveInstanceType = x.slaveInstanceType
            this.terminationProtected = x.terminationProtected
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig = JobFlowInstancesConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.PlacementType] inside the given [block]
         */
        public fun placement(block: aws.sdk.kotlin.services.emr.model.PlacementType.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.emr.model.PlacementType.invoke(block)
        }
    }
}
