// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * A description of a cluster (job flow).
 */
public class JobFlowDetail private constructor(builder: Builder) {
    /**
     * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, `ReleaseLabel` is used. To specify a custom AMI, use `CustomAmiID`.
     */
    public val amiVersion: kotlin.String? = builder.amiVersion
    /**
     * An IAM role for automatic scaling policies. The default role is `EMR_AutoScaling_DefaultRole`. The IAM role provides a way for the automatic scaling feature to get the required permissions it needs to launch and terminate EC2 instances in an instance group.
     */
    public val autoScalingRole: kotlin.String? = builder.autoScalingRole
    /**
     * A list of the bootstrap actions run by the job flow.
     */
    public val bootstrapActions: List<BootstrapActionDetail>? = builder.bootstrapActions
    /**
     * Describes the execution status of the job flow.
     */
    public val executionStatusDetail: aws.sdk.kotlin.services.emr.model.JobFlowExecutionStatusDetail? = builder.executionStatusDetail
    /**
     * Describes the Amazon EC2 instances of the job flow.
     */
    public val instances: aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail? = builder.instances
    /**
     * The job flow identifier.
     */
    public val jobFlowId: kotlin.String? = builder.jobFlowId
    /**
     * The IAM role that was specified when the job flow was launched. The EC2 instances of the job flow assume this role.
     */
    public val jobFlowRole: kotlin.String? = builder.jobFlowRole
    /**
     * The KMS key used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    public val logEncryptionKmsKeyId: kotlin.String? = builder.logEncryptionKmsKeyId
    /**
     * The location in Amazon S3 where log files for the job are stored.
     */
    public val logUri: kotlin.String? = builder.logUri
    /**
     * The name of the job flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. `TERMINATE_AT_INSTANCE_HOUR` indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. `TERMINATE_AT_TASK_COMPLETION` indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. `TERMINATE_AT_TASK_COMPLETION` available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     */
    public val scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = builder.scaleDownBehavior
    /**
     * The IAM role that is assumed by the Amazon EMR service to access Amazon Web Services resources on your behalf.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * A list of steps run by the job flow.
     */
    public val steps: List<StepDetail>? = builder.steps
    /**
     * A list of strings set by third-party software when the job flow is launched. If you are not using third-party software to manage the job flow, this value is empty.
     */
    public val supportedProducts: List<String>? = builder.supportedProducts
    /**
     * Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated with the cluster. When `true`, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.
     *
     * The default value is `true` if a value is not provided when creating a cluster using the EMR API RunJobFlow command, the CLI [create-cluster](https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html) command, or the Amazon Web Services Management Console.
     */
    public val visibleToAllUsers: kotlin.Boolean = builder.visibleToAllUsers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.JobFlowDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobFlowDetail(")
        append("amiVersion=$amiVersion,")
        append("autoScalingRole=$autoScalingRole,")
        append("bootstrapActions=$bootstrapActions,")
        append("executionStatusDetail=$executionStatusDetail,")
        append("instances=$instances,")
        append("jobFlowId=$jobFlowId,")
        append("jobFlowRole=$jobFlowRole,")
        append("logEncryptionKmsKeyId=$logEncryptionKmsKeyId,")
        append("logUri=$logUri,")
        append("name=$name,")
        append("scaleDownBehavior=$scaleDownBehavior,")
        append("serviceRole=$serviceRole,")
        append("steps=$steps,")
        append("supportedProducts=$supportedProducts,")
        append("visibleToAllUsers=$visibleToAllUsers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiVersion?.hashCode() ?: 0
        result = 31 * result + (autoScalingRole?.hashCode() ?: 0)
        result = 31 * result + (bootstrapActions?.hashCode() ?: 0)
        result = 31 * result + (executionStatusDetail?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (jobFlowId?.hashCode() ?: 0)
        result = 31 * result + (jobFlowRole?.hashCode() ?: 0)
        result = 31 * result + (logEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scaleDownBehavior?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (steps?.hashCode() ?: 0)
        result = 31 * result + (supportedProducts?.hashCode() ?: 0)
        result = 31 * result + (visibleToAllUsers.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobFlowDetail

        if (amiVersion != other.amiVersion) return false
        if (autoScalingRole != other.autoScalingRole) return false
        if (bootstrapActions != other.bootstrapActions) return false
        if (executionStatusDetail != other.executionStatusDetail) return false
        if (instances != other.instances) return false
        if (jobFlowId != other.jobFlowId) return false
        if (jobFlowRole != other.jobFlowRole) return false
        if (logEncryptionKmsKeyId != other.logEncryptionKmsKeyId) return false
        if (logUri != other.logUri) return false
        if (name != other.name) return false
        if (scaleDownBehavior != other.scaleDownBehavior) return false
        if (serviceRole != other.serviceRole) return false
        if (steps != other.steps) return false
        if (supportedProducts != other.supportedProducts) return false
        if (visibleToAllUsers != other.visibleToAllUsers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.JobFlowDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, `ReleaseLabel` is used. To specify a custom AMI, use `CustomAmiID`.
         */
        public var amiVersion: kotlin.String? = null
        /**
         * An IAM role for automatic scaling policies. The default role is `EMR_AutoScaling_DefaultRole`. The IAM role provides a way for the automatic scaling feature to get the required permissions it needs to launch and terminate EC2 instances in an instance group.
         */
        public var autoScalingRole: kotlin.String? = null
        /**
         * A list of the bootstrap actions run by the job flow.
         */
        public var bootstrapActions: List<BootstrapActionDetail>? = null
        /**
         * Describes the execution status of the job flow.
         */
        public var executionStatusDetail: aws.sdk.kotlin.services.emr.model.JobFlowExecutionStatusDetail? = null
        /**
         * Describes the Amazon EC2 instances of the job flow.
         */
        public var instances: aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail? = null
        /**
         * The job flow identifier.
         */
        public var jobFlowId: kotlin.String? = null
        /**
         * The IAM role that was specified when the job flow was launched. The EC2 instances of the job flow assume this role.
         */
        public var jobFlowRole: kotlin.String? = null
        /**
         * The KMS key used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
         */
        public var logEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The location in Amazon S3 where log files for the job are stored.
         */
        public var logUri: kotlin.String? = null
        /**
         * The name of the job flow.
         */
        public var name: kotlin.String? = null
        /**
         * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. `TERMINATE_AT_INSTANCE_HOUR` indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. `TERMINATE_AT_TASK_COMPLETION` indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. `TERMINATE_AT_TASK_COMPLETION` available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         */
        public var scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = null
        /**
         * The IAM role that is assumed by the Amazon EMR service to access Amazon Web Services resources on your behalf.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * A list of steps run by the job flow.
         */
        public var steps: List<StepDetail>? = null
        /**
         * A list of strings set by third-party software when the job flow is launched. If you are not using third-party software to manage the job flow, this value is empty.
         */
        public var supportedProducts: List<String>? = null
        /**
         * Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated with the cluster. When `true`, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.
         *
         * The default value is `true` if a value is not provided when creating a cluster using the EMR API RunJobFlow command, the CLI [create-cluster](https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html) command, or the Amazon Web Services Management Console.
         */
        public var visibleToAllUsers: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.JobFlowDetail) : this() {
            this.amiVersion = x.amiVersion
            this.autoScalingRole = x.autoScalingRole
            this.bootstrapActions = x.bootstrapActions
            this.executionStatusDetail = x.executionStatusDetail
            this.instances = x.instances
            this.jobFlowId = x.jobFlowId
            this.jobFlowRole = x.jobFlowRole
            this.logEncryptionKmsKeyId = x.logEncryptionKmsKeyId
            this.logUri = x.logUri
            this.name = x.name
            this.scaleDownBehavior = x.scaleDownBehavior
            this.serviceRole = x.serviceRole
            this.steps = x.steps
            this.supportedProducts = x.supportedProducts
            this.visibleToAllUsers = x.visibleToAllUsers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.JobFlowDetail = JobFlowDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.JobFlowExecutionStatusDetail] inside the given [block]
         */
        public fun executionStatusDetail(block: aws.sdk.kotlin.services.emr.model.JobFlowExecutionStatusDetail.Builder.() -> kotlin.Unit) {
            this.executionStatusDetail = aws.sdk.kotlin.services.emr.model.JobFlowExecutionStatusDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail] inside the given [block]
         */
        public fun instances(block: aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail.Builder.() -> kotlin.Unit) {
            this.instances = aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail.invoke(block)
        }
    }
}
