// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Configuration parameters for an instance fleet modification request.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
public class InstanceFleetModifyConfig private constructor(builder: Builder) {
    /**
     * A unique identifier for the instance fleet.
     */
    public val instanceFleetId: kotlin.String? = builder.instanceFleetId
    /**
     * The resize specification for the instance fleet.
     */
    public val resizeSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications? = builder.resizeSpecifications
    /**
     * The target capacity of On-Demand units for the instance fleet. For more information see InstanceFleetConfig$TargetOnDemandCapacity.
     */
    public val targetOnDemandCapacity: kotlin.Int? = builder.targetOnDemandCapacity
    /**
     * The target capacity of Spot units for the instance fleet. For more information, see InstanceFleetConfig$TargetSpotCapacity.
     */
    public val targetSpotCapacity: kotlin.Int? = builder.targetSpotCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceFleetModifyConfig(")
        append("instanceFleetId=$instanceFleetId,")
        append("resizeSpecifications=$resizeSpecifications,")
        append("targetOnDemandCapacity=$targetOnDemandCapacity,")
        append("targetSpotCapacity=$targetSpotCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceFleetId?.hashCode() ?: 0
        result = 31 * result + (resizeSpecifications?.hashCode() ?: 0)
        result = 31 * result + (targetOnDemandCapacity ?: 0)
        result = 31 * result + (targetSpotCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceFleetModifyConfig

        if (instanceFleetId != other.instanceFleetId) return false
        if (resizeSpecifications != other.resizeSpecifications) return false
        if (targetOnDemandCapacity != other.targetOnDemandCapacity) return false
        if (targetSpotCapacity != other.targetSpotCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the instance fleet.
         */
        public var instanceFleetId: kotlin.String? = null
        /**
         * The resize specification for the instance fleet.
         */
        public var resizeSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications? = null
        /**
         * The target capacity of On-Demand units for the instance fleet. For more information see InstanceFleetConfig$TargetOnDemandCapacity.
         */
        public var targetOnDemandCapacity: kotlin.Int? = null
        /**
         * The target capacity of Spot units for the instance fleet. For more information, see InstanceFleetConfig$TargetSpotCapacity.
         */
        public var targetSpotCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig) : this() {
            this.instanceFleetId = x.instanceFleetId
            this.resizeSpecifications = x.resizeSpecifications
            this.targetOnDemandCapacity = x.targetOnDemandCapacity
            this.targetSpotCapacity = x.targetSpotCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig = InstanceFleetModifyConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications] inside the given [block]
         */
        public fun resizeSpecifications(block: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications.Builder.() -> kotlin.Unit) {
            this.resizeSpecifications = aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications.invoke(block)
        }
    }
}
