// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * The configuration that defines an instance fleet.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
public class InstanceFleetConfig private constructor(builder: Builder) {
    /**
     * The node type that the instance fleet hosts. Valid values are MASTER, CORE, and TASK.
     */
    public val instanceFleetType: aws.sdk.kotlin.services.emr.model.InstanceFleetType? = builder.instanceFleetType
    /**
     * The instance type configurations that define the EC2 instances in the instance fleet.
     */
    public val instanceTypeConfigs: List<InstanceTypeConfig>? = builder.instanceTypeConfigs
    /**
     * The launch specification for the instance fleet.
     */
    public val launchSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications? = builder.launchSpecifications
    /**
     * The friendly name of the instance fleet.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The resize specification for the instance fleet.
     */
    public val resizeSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications? = builder.resizeSpecifications
    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When an On-Demand Instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
     *
     * If not specified or set to 0, only Spot Instances are provisioned for the instance fleet using `TargetSpotCapacity`. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
     */
    public val targetOnDemandCapacity: kotlin.Int? = builder.targetOnDemandCapacity
    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot Instances to provision. When the instance fleet launches, Amazon EMR tries to provision Spot Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When a Spot Instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
     *
     * If not specified or set to 0, only On-Demand Instances are provisioned for the instance fleet. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
     */
    public val targetSpotCapacity: kotlin.Int? = builder.targetSpotCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceFleetConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceFleetConfig(")
        append("instanceFleetType=$instanceFleetType,")
        append("instanceTypeConfigs=$instanceTypeConfigs,")
        append("launchSpecifications=$launchSpecifications,")
        append("name=$name,")
        append("resizeSpecifications=$resizeSpecifications,")
        append("targetOnDemandCapacity=$targetOnDemandCapacity,")
        append("targetSpotCapacity=$targetSpotCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceFleetType?.hashCode() ?: 0
        result = 31 * result + (instanceTypeConfigs?.hashCode() ?: 0)
        result = 31 * result + (launchSpecifications?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resizeSpecifications?.hashCode() ?: 0)
        result = 31 * result + (targetOnDemandCapacity ?: 0)
        result = 31 * result + (targetSpotCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceFleetConfig

        if (instanceFleetType != other.instanceFleetType) return false
        if (instanceTypeConfigs != other.instanceTypeConfigs) return false
        if (launchSpecifications != other.launchSpecifications) return false
        if (name != other.name) return false
        if (resizeSpecifications != other.resizeSpecifications) return false
        if (targetOnDemandCapacity != other.targetOnDemandCapacity) return false
        if (targetSpotCapacity != other.targetSpotCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceFleetConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The node type that the instance fleet hosts. Valid values are MASTER, CORE, and TASK.
         */
        public var instanceFleetType: aws.sdk.kotlin.services.emr.model.InstanceFleetType? = null
        /**
         * The instance type configurations that define the EC2 instances in the instance fleet.
         */
        public var instanceTypeConfigs: List<InstanceTypeConfig>? = null
        /**
         * The launch specification for the instance fleet.
         */
        public var launchSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications? = null
        /**
         * The friendly name of the instance fleet.
         */
        public var name: kotlin.String? = null
        /**
         * The resize specification for the instance fleet.
         */
        public var resizeSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications? = null
        /**
         * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When an On-Demand Instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         *
         * If not specified or set to 0, only Spot Instances are provisioned for the instance fleet using `TargetSpotCapacity`. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
         */
        public var targetOnDemandCapacity: kotlin.Int? = null
        /**
         * The target capacity of Spot units for the instance fleet, which determines how many Spot Instances to provision. When the instance fleet launches, Amazon EMR tries to provision Spot Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When a Spot Instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         *
         * If not specified or set to 0, only On-Demand Instances are provisioned for the instance fleet. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
         */
        public var targetSpotCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceFleetConfig) : this() {
            this.instanceFleetType = x.instanceFleetType
            this.instanceTypeConfigs = x.instanceTypeConfigs
            this.launchSpecifications = x.launchSpecifications
            this.name = x.name
            this.resizeSpecifications = x.resizeSpecifications
            this.targetOnDemandCapacity = x.targetOnDemandCapacity
            this.targetSpotCapacity = x.targetSpotCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceFleetConfig = InstanceFleetConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications] inside the given [block]
         */
        public fun launchSpecifications(block: aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications.Builder.() -> kotlin.Unit) {
            this.launchSpecifications = aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications] inside the given [block]
         */
        public fun resizeSpecifications(block: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications.Builder.() -> kotlin.Unit) {
            this.resizeSpecifications = aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications.invoke(block)
        }
    }
}
