// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.waiters

import aws.sdk.kotlin.services.emr.EmrClient
import aws.sdk.kotlin.services.emr.model.DescribeClusterRequest
import aws.sdk.kotlin.services.emr.model.DescribeClusterResponse
import aws.sdk.kotlin.services.emr.model.DescribeStepRequest
import aws.sdk.kotlin.services.emr.model.DescribeStepResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun EmrClient.waitUntilClusterRunning(request: DescribeClusterRequest): Outcome<DescribeClusterResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeClusterRequest, DescribeClusterResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "RUNNING"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "WAITING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "TERMINATING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "TERMINATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "TERMINATED_WITH_ERRORS"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCluster(request) }
}

public suspend fun EmrClient.waitUntilClusterRunning(block: DescribeClusterRequest.Builder.() -> Unit): Outcome<DescribeClusterResponse> =
    waitUntilClusterRunning(DescribeClusterRequest.Builder().apply(block).build())

public suspend fun EmrClient.waitUntilClusterTerminated(request: DescribeClusterRequest): Outcome<DescribeClusterResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeClusterRequest, DescribeClusterResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "TERMINATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it.cluster
            val status = cluster?.status
            val state = status?.state?.value
            state == "TERMINATED_WITH_ERRORS"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCluster(request) }
}

public suspend fun EmrClient.waitUntilClusterTerminated(block: DescribeClusterRequest.Builder.() -> Unit): Outcome<DescribeClusterResponse> =
    waitUntilClusterTerminated(DescribeClusterRequest.Builder().apply(block).build())

public suspend fun EmrClient.waitUntilStepComplete(request: DescribeStepRequest): Outcome<DescribeStepResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStepRequest, DescribeStepResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val step = it.step
            val status = step?.status
            val state = status?.state?.value
            state == "COMPLETED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val step = it.step
            val status = step?.status
            val state = status?.state?.value
            state == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val step = it.step
            val status = step?.status
            val state = status?.state?.value
            state == "CANCELLED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStep(request) }
}

public suspend fun EmrClient.waitUntilStepComplete(block: DescribeStepRequest.Builder.() -> Unit): Outcome<DescribeStepResponse> =
    waitUntilStepComplete(DescribeStepRequest.Builder().apply(block).build())
