// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.serde

import aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription
import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.PutAutoScalingPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutAutoScalingPolicyOperationDeserializer: HttpDeserializer.NonStreaming<PutAutoScalingPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutAutoScalingPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutAutoScalingPolicyError(context, call, payload)
        }
        val builder = PutAutoScalingPolicyResponse.Builder()

        if (payload != null) {
            deserializePutAutoScalingPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutAutoScalingPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutAutoScalingPolicyOperationBody(builder: PutAutoScalingPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOSCALINGPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoScalingPolicy"))
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterArn"))
    val CLUSTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterId"))
    val INSTANCEGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceGroupId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOSCALINGPOLICY_DESCRIPTOR)
        field(CLUSTERARN_DESCRIPTOR)
        field(CLUSTERID_DESCRIPTOR)
        field(INSTANCEGROUPID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOSCALINGPOLICY_DESCRIPTOR.index -> builder.autoScalingPolicy = deserializeAutoScalingPolicyDescriptionDocument(deserializer)
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                CLUSTERID_DESCRIPTOR.index -> builder.clusterId = deserializeString()
                INSTANCEGROUPID_DESCRIPTOR.index -> builder.instanceGroupId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
