// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.serde

import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.ListSupportedInstanceTypesResponse
import aws.sdk.kotlin.services.emr.model.SupportedInstanceType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListSupportedInstanceTypesOperationDeserializer: HttpDeserializer.NonStreaming<ListSupportedInstanceTypesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListSupportedInstanceTypesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListSupportedInstanceTypesError(context, call, payload)
        }
        val builder = ListSupportedInstanceTypesResponse.Builder()

        if (payload != null) {
            deserializeListSupportedInstanceTypesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListSupportedInstanceTypesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListSupportedInstanceTypesOperationBody(builder: ListSupportedInstanceTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val SUPPORTEDINSTANCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupportedInstanceTypes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MARKER_DESCRIPTOR)
        field(SUPPORTEDINSTANCETYPES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                SUPPORTEDINSTANCETYPES_DESCRIPTOR.index -> builder.supportedInstanceTypes =
                    deserializer.deserializeList(SUPPORTEDINSTANCETYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<SupportedInstanceType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSupportedInstanceTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
