// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for an Amazon EMR Studio, including ID, Name, VPC, and Description. To fetch additional details such as subnets, IAM roles, security groups, and tags for the Studio, use the DescribeStudio API.
 */
public class StudioSummary private constructor(builder: Builder) {
    /**
     * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
     */
    public val authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = builder.authMode
    /**
     * The time when the Amazon EMR Studio was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The detailed description of the Amazon EMR Studio.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the Amazon EMR Studio.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the Amazon EMR Studio.
     */
    public val studioId: kotlin.String? = builder.studioId
    /**
     * The unique access URL of the Amazon EMR Studio.
     */
    public val url: kotlin.String? = builder.url
    /**
     * The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.StudioSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StudioSummary(")
        append("authMode=$authMode,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("name=$name,")
        append("studioId=$studioId,")
        append("url=$url,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authMode?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (studioId?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StudioSummary

        if (authMode != other.authMode) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (studioId != other.studioId) return false
        if (url != other.url) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.StudioSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
         */
        public var authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = null
        /**
         * The time when the Amazon EMR Studio was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The detailed description of the Amazon EMR Studio.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the Amazon EMR Studio.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio.
         */
        public var studioId: kotlin.String? = null
        /**
         * The unique access URL of the Amazon EMR Studio.
         */
        public var url: kotlin.String? = null
        /**
         * The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.StudioSummary) : this() {
            this.authMode = x.authMode
            this.creationTime = x.creationTime
            this.description = x.description
            this.name = x.name
            this.studioId = x.studioId
            this.url = x.url
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.StudioSummary = StudioSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
