// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specification for a cluster (job flow) step.
 */
public class StepConfig private constructor(builder: Builder) {
    /**
     * The action to take when the step fails. Use one of the following values:
     * + `TERMINATE_CLUSTER` - Shuts down the cluster.
     * + `CANCEL_AND_WAIT` - Cancels any pending steps and returns the cluster to the `WAITING` state.
     * + `CONTINUE` - Continues to the next step in the queue.
     * + `TERMINATE_JOB_FLOW` - Shuts down the cluster. `TERMINATE_JOB_FLOW` is provided for backward compatibility. We recommend using `TERMINATE_CLUSTER` instead.
     *
     * If a cluster's `StepConcurrencyLevel` is greater than `1`, do not use `AddJobFlowSteps` to submit a step with this parameter set to `CANCEL_AND_WAIT` or `TERMINATE_CLUSTER`. The step is not submitted and the action fails with a message that the `ActionOnFailure` setting is not valid.
     *
     * If you change a cluster's `StepConcurrencyLevel` to be greater than 1 while a step is running, the `ActionOnFailure` parameter may not behave as you expect. In this case, for a step that fails with this parameter set to `CANCEL_AND_WAIT`, pending steps and the running step are not canceled; for a step that fails with this parameter set to `TERMINATE_CLUSTER`, the cluster does not terminate.
     */
    public val actionOnFailure: aws.sdk.kotlin.services.emr.model.ActionOnFailure? = builder.actionOnFailure
    /**
     * The JAR file used for the step.
     */
    public val hadoopJarStep: aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig? = builder.hadoopJarStep
    /**
     * The name of the step.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.StepConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StepConfig(")
        append("actionOnFailure=$actionOnFailure,")
        append("hadoopJarStep=$hadoopJarStep,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionOnFailure?.hashCode() ?: 0
        result = 31 * result + (hadoopJarStep?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StepConfig

        if (actionOnFailure != other.actionOnFailure) return false
        if (hadoopJarStep != other.hadoopJarStep) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.StepConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action to take when the step fails. Use one of the following values:
         * + `TERMINATE_CLUSTER` - Shuts down the cluster.
         * + `CANCEL_AND_WAIT` - Cancels any pending steps and returns the cluster to the `WAITING` state.
         * + `CONTINUE` - Continues to the next step in the queue.
         * + `TERMINATE_JOB_FLOW` - Shuts down the cluster. `TERMINATE_JOB_FLOW` is provided for backward compatibility. We recommend using `TERMINATE_CLUSTER` instead.
         *
         * If a cluster's `StepConcurrencyLevel` is greater than `1`, do not use `AddJobFlowSteps` to submit a step with this parameter set to `CANCEL_AND_WAIT` or `TERMINATE_CLUSTER`. The step is not submitted and the action fails with a message that the `ActionOnFailure` setting is not valid.
         *
         * If you change a cluster's `StepConcurrencyLevel` to be greater than 1 while a step is running, the `ActionOnFailure` parameter may not behave as you expect. In this case, for a step that fails with this parameter set to `CANCEL_AND_WAIT`, pending steps and the running step are not canceled; for a step that fails with this parameter set to `TERMINATE_CLUSTER`, the cluster does not terminate.
         */
        public var actionOnFailure: aws.sdk.kotlin.services.emr.model.ActionOnFailure? = null
        /**
         * The JAR file used for the step.
         */
        public var hadoopJarStep: aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig? = null
        /**
         * The name of the step.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.StepConfig) : this() {
            this.actionOnFailure = x.actionOnFailure
            this.hadoopJarStep = x.hadoopJarStep
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.StepConfig = StepConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig] inside the given [block]
         */
        public fun hadoopJarStep(block: aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig.Builder.() -> kotlin.Unit) {
            this.hadoopJarStep = aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
