// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartNotebookExecutionRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the Amazon EMR Notebook to use for notebook execution.
     */
    public val editorId: kotlin.String? = builder.editorId
    /**
     * The environment variables associated with the notebook execution.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * Specifies the execution engine (cluster) that runs the notebook execution.
     */
    public val executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = builder.executionEngine
    /**
     * An optional name for the notebook execution.
     */
    public val notebookExecutionName: kotlin.String? = builder.notebookExecutionName
    /**
     * The unique identifier of the Amazon EC2 security group to associate with the Amazon EMR Notebook for this notebook execution.
     */
    public val notebookInstanceSecurityGroupId: kotlin.String? = builder.notebookInstanceSecurityGroupId
    /**
     * Input parameters in JSON format passed to the Amazon EMR Notebook at runtime for execution.
     */
    public val notebookParams: kotlin.String? = builder.notebookParams
    /**
     * The Amazon S3 location for the notebook execution input.
     */
    public val notebookS3Location: aws.sdk.kotlin.services.emr.model.NotebookS3LocationFromInput? = builder.notebookS3Location
    /**
     * The output format for the notebook execution.
     */
    public val outputNotebookFormat: aws.sdk.kotlin.services.emr.model.OutputNotebookFormat? = builder.outputNotebookFormat
    /**
     * The Amazon S3 location for the notebook execution output.
     */
    public val outputNotebookS3Location: aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationFromInput? = builder.outputNotebookS3Location
    /**
     * The path and file name of the notebook file for this execution, relative to the path specified for the Amazon EMR Notebook. For example, if you specify a path of `s3://MyBucket/MyNotebooks` when you create an Amazon EMR Notebook for a notebook with an ID of `e-ABCDEFGHIJK1234567890ABCD` (the `EditorID` of this request), and you specify a `RelativePath` of `my_notebook_executions/notebook_execution.ipynb`, the location of the file for the notebook execution is `s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb`.
     */
    public val relativePath: kotlin.String? = builder.relativePath
    /**
     * The name or ARN of the IAM role that is used as the service role for Amazon EMR (the Amazon EMR role) for the notebook execution.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartNotebookExecutionRequest(")
        append("editorId=$editorId,")
        append("environmentVariables=$environmentVariables,")
        append("executionEngine=$executionEngine,")
        append("notebookExecutionName=$notebookExecutionName,")
        append("notebookInstanceSecurityGroupId=$notebookInstanceSecurityGroupId,")
        append("notebookParams=$notebookParams,")
        append("notebookS3Location=$notebookS3Location,")
        append("outputNotebookFormat=$outputNotebookFormat,")
        append("outputNotebookS3Location=$outputNotebookS3Location,")
        append("relativePath=$relativePath,")
        append("serviceRole=$serviceRole,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = editorId?.hashCode() ?: 0
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (executionEngine?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (notebookParams?.hashCode() ?: 0)
        result = 31 * result + (notebookS3Location?.hashCode() ?: 0)
        result = 31 * result + (outputNotebookFormat?.hashCode() ?: 0)
        result = 31 * result + (outputNotebookS3Location?.hashCode() ?: 0)
        result = 31 * result + (relativePath?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartNotebookExecutionRequest

        if (editorId != other.editorId) return false
        if (environmentVariables != other.environmentVariables) return false
        if (executionEngine != other.executionEngine) return false
        if (notebookExecutionName != other.notebookExecutionName) return false
        if (notebookInstanceSecurityGroupId != other.notebookInstanceSecurityGroupId) return false
        if (notebookParams != other.notebookParams) return false
        if (notebookS3Location != other.notebookS3Location) return false
        if (outputNotebookFormat != other.outputNotebookFormat) return false
        if (outputNotebookS3Location != other.outputNotebookS3Location) return false
        if (relativePath != other.relativePath) return false
        if (serviceRole != other.serviceRole) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the Amazon EMR Notebook to use for notebook execution.
         */
        public var editorId: kotlin.String? = null
        /**
         * The environment variables associated with the notebook execution.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * Specifies the execution engine (cluster) that runs the notebook execution.
         */
        public var executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = null
        /**
         * An optional name for the notebook execution.
         */
        public var notebookExecutionName: kotlin.String? = null
        /**
         * The unique identifier of the Amazon EC2 security group to associate with the Amazon EMR Notebook for this notebook execution.
         */
        public var notebookInstanceSecurityGroupId: kotlin.String? = null
        /**
         * Input parameters in JSON format passed to the Amazon EMR Notebook at runtime for execution.
         */
        public var notebookParams: kotlin.String? = null
        /**
         * The Amazon S3 location for the notebook execution input.
         */
        public var notebookS3Location: aws.sdk.kotlin.services.emr.model.NotebookS3LocationFromInput? = null
        /**
         * The output format for the notebook execution.
         */
        public var outputNotebookFormat: aws.sdk.kotlin.services.emr.model.OutputNotebookFormat? = null
        /**
         * The Amazon S3 location for the notebook execution output.
         */
        public var outputNotebookS3Location: aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationFromInput? = null
        /**
         * The path and file name of the notebook file for this execution, relative to the path specified for the Amazon EMR Notebook. For example, if you specify a path of `s3://MyBucket/MyNotebooks` when you create an Amazon EMR Notebook for a notebook with an ID of `e-ABCDEFGHIJK1234567890ABCD` (the `EditorID` of this request), and you specify a `RelativePath` of `my_notebook_executions/notebook_execution.ipynb`, the location of the file for the notebook execution is `s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb`.
         */
        public var relativePath: kotlin.String? = null
        /**
         * The name or ARN of the IAM role that is used as the service role for Amazon EMR (the Amazon EMR role) for the notebook execution.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest) : this() {
            this.editorId = x.editorId
            this.environmentVariables = x.environmentVariables
            this.executionEngine = x.executionEngine
            this.notebookExecutionName = x.notebookExecutionName
            this.notebookInstanceSecurityGroupId = x.notebookInstanceSecurityGroupId
            this.notebookParams = x.notebookParams
            this.notebookS3Location = x.notebookS3Location
            this.outputNotebookFormat = x.outputNotebookFormat
            this.outputNotebookS3Location = x.outputNotebookS3Location
            this.relativePath = x.relativePath
            this.serviceRole = x.serviceRole
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest = StartNotebookExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig] inside the given [block]
         */
        public fun executionEngine(block: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.Builder.() -> kotlin.Unit) {
            this.executionEngine = aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.NotebookS3LocationFromInput] inside the given [block]
         */
        public fun notebookS3Location(block: aws.sdk.kotlin.services.emr.model.NotebookS3LocationFromInput.Builder.() -> kotlin.Unit) {
            this.notebookS3Location = aws.sdk.kotlin.services.emr.model.NotebookS3LocationFromInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationFromInput] inside the given [block]
         */
        public fun outputNotebookS3Location(block: aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationFromInput.Builder.() -> kotlin.Unit) {
            this.outputNotebookS3Location = aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationFromInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
