// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The launch specification for Spot Instances in the instance fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.
 *
 * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions. Spot Instance allocation strategy is available in Amazon EMR releases 5.12.1 and later.
 *
 * Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
 */
public class SpotProvisioningSpecification private constructor(builder: Builder) {
    /**
     * Specifies one of the following strategies to launch Spot Instance fleets: `capacity-optimized`, `price-capacity-optimized`, `lowest-price`, or `diversified`, and `capacity-optimized-prioritized`. For more information on the provisioning strategies, see [Allocation strategies for Spot Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * When you launch a Spot Instance fleet with the old console, it automatically launches with the `capacity-optimized` strategy. You can't change the allocation strategy from the old console.
     */
    public val allocationStrategy: aws.sdk.kotlin.services.emr.model.SpotProvisioningAllocationStrategy? = builder.allocationStrategy
    /**
     * The defined duration for Spot Instances (also known as Spot blocks) in minutes. When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.
     *
     * Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
     */
    public val blockDurationMinutes: kotlin.Int? = builder.blockDurationMinutes
    /**
     * The action to take when `TargetSpotCapacity` has not been fulfilled when the `TimeoutDurationMinutes` has expired; that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
     */
    public val timeoutAction: aws.sdk.kotlin.services.emr.model.SpotProvisioningTimeoutAction? = builder.timeoutAction
    /**
     * The Spot provisioning timeout period in minutes. If Spot Instances are not provisioned within this time period, the `TimeOutAction` is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
     */
    public val timeoutDurationMinutes: kotlin.Int? = builder.timeoutDurationMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.SpotProvisioningSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpotProvisioningSpecification(")
        append("allocationStrategy=$allocationStrategy,")
        append("blockDurationMinutes=$blockDurationMinutes,")
        append("timeoutAction=$timeoutAction,")
        append("timeoutDurationMinutes=$timeoutDurationMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (blockDurationMinutes ?: 0)
        result = 31 * result + (timeoutAction?.hashCode() ?: 0)
        result = 31 * result + (timeoutDurationMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpotProvisioningSpecification

        if (allocationStrategy != other.allocationStrategy) return false
        if (blockDurationMinutes != other.blockDurationMinutes) return false
        if (timeoutAction != other.timeoutAction) return false
        if (timeoutDurationMinutes != other.timeoutDurationMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.SpotProvisioningSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies one of the following strategies to launch Spot Instance fleets: `capacity-optimized`, `price-capacity-optimized`, `lowest-price`, or `diversified`, and `capacity-optimized-prioritized`. For more information on the provisioning strategies, see [Allocation strategies for Spot Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * When you launch a Spot Instance fleet with the old console, it automatically launches with the `capacity-optimized` strategy. You can't change the allocation strategy from the old console.
         */
        public var allocationStrategy: aws.sdk.kotlin.services.emr.model.SpotProvisioningAllocationStrategy? = null
        /**
         * The defined duration for Spot Instances (also known as Spot blocks) in minutes. When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.
         *
         * Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
         */
        public var blockDurationMinutes: kotlin.Int? = null
        /**
         * The action to take when `TargetSpotCapacity` has not been fulfilled when the `TimeoutDurationMinutes` has expired; that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
         */
        public var timeoutAction: aws.sdk.kotlin.services.emr.model.SpotProvisioningTimeoutAction? = null
        /**
         * The Spot provisioning timeout period in minutes. If Spot Instances are not provisioned within this time period, the `TimeOutAction` is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
         */
        public var timeoutDurationMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.SpotProvisioningSpecification) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.blockDurationMinutes = x.blockDurationMinutes
            this.timeoutAction = x.timeoutAction
            this.timeoutDurationMinutes = x.timeoutDurationMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.SpotProvisioningSpecification = SpotProvisioningSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
