// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The upper and lower Amazon EC2 instance limits for an automatic scaling policy. Automatic scaling activities triggered by automatic scaling rules will not cause an instance group to grow above or below these limits.
 */
public class ScalingConstraints private constructor(builder: Builder) {
    /**
     * The upper boundary of Amazon EC2 instances in an instance group beyond which scaling activities are not allowed to grow. Scale-out activities will not add instances beyond this boundary.
     */
    public val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The lower boundary of Amazon EC2 instances in an instance group below which scaling activities are not allowed to shrink. Scale-in activities will not terminate instances below this boundary.
     */
    public val minCapacity: kotlin.Int? = builder.minCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ScalingConstraints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingConstraints(")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacity ?: 0
        result = 31 * result + (minCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingConstraints

        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ScalingConstraints = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The upper boundary of Amazon EC2 instances in an instance group beyond which scaling activities are not allowed to grow. Scale-out activities will not add instances beyond this boundary.
         */
        public var maxCapacity: kotlin.Int? = null
        /**
         * The lower boundary of Amazon EC2 instances in an instance group below which scaling activities are not allowed to shrink. Scale-in activities will not terminate instances below this boundary.
         */
        public var minCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ScalingConstraints) : this() {
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ScalingConstraints = ScalingConstraints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
