// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Placement group configuration for an Amazon EMR cluster. The configuration specifies the placement strategy that can be applied to instance roles during cluster creation.
 *
 * To use this configuration, consider attaching managed policy AmazonElasticMapReducePlacementGroupPolicy to the Amazon EMR role.
 */
public class PlacementGroupConfig private constructor(builder: Builder) {
    /**
     * Role of the instance in the cluster.
     *
     * Starting with Amazon EMR release 5.23.0, the only supported instance role is `MASTER`.
     */
    public val instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = builder.instanceRole
    /**
     * Amazon EC2 Placement Group strategy associated with instance role.
     *
     * Starting with Amazon EMR release 5.23.0, the only supported placement strategy is `SPREAD` for the `MASTER` instance role.
     */
    public val placementStrategy: aws.sdk.kotlin.services.emr.model.PlacementGroupStrategy? = builder.placementStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.PlacementGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementGroupConfig(")
        append("instanceRole=$instanceRole,")
        append("placementStrategy=$placementStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceRole?.hashCode() ?: 0
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlacementGroupConfig

        if (instanceRole != other.instanceRole) return false
        if (placementStrategy != other.placementStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.PlacementGroupConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Role of the instance in the cluster.
         *
         * Starting with Amazon EMR release 5.23.0, the only supported instance role is `MASTER`.
         */
        public var instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = null
        /**
         * Amazon EC2 Placement Group strategy associated with instance role.
         *
         * Starting with Amazon EMR release 5.23.0, the only supported placement strategy is `SPREAD` for the `MASTER` instance role.
         */
        public var placementStrategy: aws.sdk.kotlin.services.emr.model.PlacementGroupStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.PlacementGroupConfig) : this() {
            this.instanceRole = x.instanceRole
            this.placementStrategy = x.placementStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.PlacementGroupConfig = PlacementGroupConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
