// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for a notebook execution. The details include information such as the unique ID and status of the notebook execution.
 */
public class NotebookExecutionSummary private constructor(builder: Builder) {
    /**
     * The unique identifier of the editor associated with the notebook execution.
     */
    public val editorId: kotlin.String? = builder.editorId
    /**
     * The timestamp when notebook execution started.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The unique ID of the execution engine for the notebook execution.
     */
    public val executionEngineId: kotlin.String? = builder.executionEngineId
    /**
     * The unique identifier of the notebook execution.
     */
    public val notebookExecutionId: kotlin.String? = builder.notebookExecutionId
    /**
     * The name of the notebook execution.
     */
    public val notebookExecutionName: kotlin.String? = builder.notebookExecutionName
    /**
     * The Amazon S3 location that stores the notebook execution input.
     */
    public val notebookS3Location: aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput? = builder.notebookS3Location
    /**
     * The timestamp when notebook execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the notebook execution.
     * + `START_PENDING` indicates that the cluster has received the execution request but execution has not begun.
     * + `STARTING` indicates that the execution is starting on the cluster.
     * + `RUNNING` indicates that the execution is being processed by the cluster.
     * + `FINISHING` indicates that execution processing is in the final stages.
     * + `FINISHED` indicates that the execution has completed without error.
     * + `FAILING` indicates that the execution is failing and will not finish successfully.
     * + `FAILED` indicates that the execution failed.
     * + `STOP_PENDING` indicates that the cluster has received a `StopNotebookExecution` request and the stop is pending.
     * + `STOPPING` indicates that the cluster is in the process of stopping the execution as a result of a `StopNotebookExecution` request.
     * + `STOPPED` indicates that the execution stopped because of a `StopNotebookExecution` request.
     */
    public val status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotebookExecutionSummary(")
        append("editorId=$editorId,")
        append("endTime=$endTime,")
        append("executionEngineId=$executionEngineId,")
        append("notebookExecutionId=$notebookExecutionId,")
        append("notebookExecutionName=$notebookExecutionName,")
        append("notebookS3Location=$notebookS3Location,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = editorId?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (executionEngineId?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionId?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionName?.hashCode() ?: 0)
        result = 31 * result + (notebookS3Location?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotebookExecutionSummary

        if (editorId != other.editorId) return false
        if (endTime != other.endTime) return false
        if (executionEngineId != other.executionEngineId) return false
        if (notebookExecutionId != other.notebookExecutionId) return false
        if (notebookExecutionName != other.notebookExecutionName) return false
        if (notebookS3Location != other.notebookS3Location) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the editor associated with the notebook execution.
         */
        public var editorId: kotlin.String? = null
        /**
         * The timestamp when notebook execution started.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID of the execution engine for the notebook execution.
         */
        public var executionEngineId: kotlin.String? = null
        /**
         * The unique identifier of the notebook execution.
         */
        public var notebookExecutionId: kotlin.String? = null
        /**
         * The name of the notebook execution.
         */
        public var notebookExecutionName: kotlin.String? = null
        /**
         * The Amazon S3 location that stores the notebook execution input.
         */
        public var notebookS3Location: aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput? = null
        /**
         * The timestamp when notebook execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the notebook execution.
         * + `START_PENDING` indicates that the cluster has received the execution request but execution has not begun.
         * + `STARTING` indicates that the execution is starting on the cluster.
         * + `RUNNING` indicates that the execution is being processed by the cluster.
         * + `FINISHING` indicates that execution processing is in the final stages.
         * + `FINISHED` indicates that the execution has completed without error.
         * + `FAILING` indicates that the execution is failing and will not finish successfully.
         * + `FAILED` indicates that the execution failed.
         * + `STOP_PENDING` indicates that the cluster has received a `StopNotebookExecution` request and the stop is pending.
         * + `STOPPING` indicates that the cluster is in the process of stopping the execution as a result of a `StopNotebookExecution` request.
         * + `STOPPED` indicates that the execution stopped because of a `StopNotebookExecution` request.
         */
        public var status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary) : this() {
            this.editorId = x.editorId
            this.endTime = x.endTime
            this.executionEngineId = x.executionEngineId
            this.notebookExecutionId = x.notebookExecutionId
            this.notebookExecutionName = x.notebookExecutionName
            this.notebookS3Location = x.notebookS3Location
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary = NotebookExecutionSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput] inside the given [block]
         */
        public fun notebookS3Location(block: aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput.Builder.() -> kotlin.Unit) {
            this.notebookS3Location = aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
