// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This input determines which steps to list.
 */
public class ListStepsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the cluster for which to list the steps.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * The maximum number of steps that a single `ListSteps` action returns is 50. To return a longer list of steps, use multiple `ListSteps` actions along with the `Marker` parameter, which is a pagination token that indicates the next set of results to retrieve.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array.
     */
    public val stepIds: List<String>? = builder.stepIds
    /**
     * The filter to limit the step list based on certain states.
     */
    public val stepStates: List<StepState>? = builder.stepStates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ListStepsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListStepsRequest(")
        append("clusterId=$clusterId,")
        append("marker=$marker,")
        append("stepIds=$stepIds,")
        append("stepStates=$stepStates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterId?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (stepIds?.hashCode() ?: 0)
        result = 31 * result + (stepStates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListStepsRequest

        if (clusterId != other.clusterId) return false
        if (marker != other.marker) return false
        if (stepIds != other.stepIds) return false
        if (stepStates != other.stepStates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ListStepsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the cluster for which to list the steps.
         */
        public var clusterId: kotlin.String? = null
        /**
         * The maximum number of steps that a single `ListSteps` action returns is 50. To return a longer list of steps, use multiple `ListSteps` actions along with the `Marker` parameter, which is a pagination token that indicates the next set of results to retrieve.
         */
        public var marker: kotlin.String? = null
        /**
         * The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array.
         */
        public var stepIds: List<String>? = null
        /**
         * The filter to limit the step list based on certain states.
         */
        public var stepStates: List<StepState>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ListStepsRequest) : this() {
            this.clusterId = x.clusterId
            this.marker = x.marker
            this.stepIds = x.stepIds
            this.stepStates = x.stepStates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ListStepsRequest = ListStepsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
