// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration specification for each instance type in an instance fleet.
 *
 * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions.
 */
public class InstanceTypeSpecification private constructor(builder: Builder) {
    /**
     * The bid price for each Amazon EC2 Spot Instance type as defined by `InstanceType`. Expressed in USD.
     */
    public val bidPrice: kotlin.String? = builder.bidPrice
    /**
     * The bid price, as a percentage of On-Demand price, for each Amazon EC2 Spot Instance as defined by `InstanceType`. Expressed as a number (for example, 20 specifies 20%).
     */
    public val bidPriceAsPercentageOfOnDemandPrice: kotlin.Double? = builder.bidPriceAsPercentageOfOnDemandPrice
    /**
     * A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR.
     */
    public val configurations: List<Configuration>? = builder.configurations
    /**
     * The custom AMI ID to use for the instance type.
     */
    public val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType`.
     */
    public val ebsBlockDevices: List<EbsBlockDevice>? = builder.ebsBlockDevices
    /**
     * Evaluates to `TRUE` when the specified `InstanceType` is EBS-optimized.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The Amazon EC2 instance type, for example `m3.xlarge`.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The priority at which Amazon EMR launches the Amazon EC2 instances with this instance type. Priority starts at 0, which is the highest priority. Amazon EMR considers the highest priority first.
     */
    public val priority: kotlin.Double? = builder.priority
    /**
     * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in InstanceFleetConfig. Capacity values represent performance characteristics such as vCPUs, memory, or I/O. If not specified, the default value is 1.
     */
    public val weightedCapacity: kotlin.Int? = builder.weightedCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceTypeSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceTypeSpecification(")
        append("bidPrice=$bidPrice,")
        append("bidPriceAsPercentageOfOnDemandPrice=$bidPriceAsPercentageOfOnDemandPrice,")
        append("configurations=$configurations,")
        append("customAmiId=$customAmiId,")
        append("ebsBlockDevices=$ebsBlockDevices,")
        append("ebsOptimized=$ebsOptimized,")
        append("instanceType=$instanceType,")
        append("priority=$priority,")
        append("weightedCapacity=$weightedCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bidPrice?.hashCode() ?: 0
        result = 31 * result + (bidPriceAsPercentageOfOnDemandPrice?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsBlockDevices?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (priority?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceTypeSpecification

        if (bidPrice != other.bidPrice) return false
        if (!(bidPriceAsPercentageOfOnDemandPrice?.equals(other.bidPriceAsPercentageOfOnDemandPrice) ?: (other.bidPriceAsPercentageOfOnDemandPrice == null))) return false
        if (configurations != other.configurations) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsBlockDevices != other.ebsBlockDevices) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (instanceType != other.instanceType) return false
        if (!(priority?.equals(other.priority) ?: (other.priority == null))) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceTypeSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The bid price for each Amazon EC2 Spot Instance type as defined by `InstanceType`. Expressed in USD.
         */
        public var bidPrice: kotlin.String? = null
        /**
         * The bid price, as a percentage of On-Demand price, for each Amazon EC2 Spot Instance as defined by `InstanceType`. Expressed as a number (for example, 20 specifies 20%).
         */
        public var bidPriceAsPercentageOfOnDemandPrice: kotlin.Double? = null
        /**
         * A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR.
         */
        public var configurations: List<Configuration>? = null
        /**
         * The custom AMI ID to use for the instance type.
         */
        public var customAmiId: kotlin.String? = null
        /**
         * The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType`.
         */
        public var ebsBlockDevices: List<EbsBlockDevice>? = null
        /**
         * Evaluates to `TRUE` when the specified `InstanceType` is EBS-optimized.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The Amazon EC2 instance type, for example `m3.xlarge`.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The priority at which Amazon EMR launches the Amazon EC2 instances with this instance type. Priority starts at 0, which is the highest priority. Amazon EMR considers the highest priority first.
         */
        public var priority: kotlin.Double? = null
        /**
         * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in InstanceFleetConfig. Capacity values represent performance characteristics such as vCPUs, memory, or I/O. If not specified, the default value is 1.
         */
        public var weightedCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceTypeSpecification) : this() {
            this.bidPrice = x.bidPrice
            this.bidPriceAsPercentageOfOnDemandPrice = x.bidPriceAsPercentageOfOnDemandPrice
            this.configurations = x.configurations
            this.customAmiId = x.customAmiId
            this.ebsBlockDevices = x.ebsBlockDevices
            this.ebsOptimized = x.ebsOptimized
            this.instanceType = x.instanceType
            this.priority = x.priority
            this.weightedCapacity = x.weightedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceTypeSpecification = InstanceTypeSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
