// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an instance group.
 */
public class InstanceGroupDetail private constructor(builder: Builder) {
    /**
     * If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify `OnDemandPrice` to set the amount equal to the On-Demand price, or specify an amount in USD.
     */
    public val bidPrice: kotlin.String? = builder.bidPrice
    /**
     * The date/time the instance group was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The custom AMI ID to use for the provisioned instance group.
     */
    public val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The date/time the instance group was terminated.
     */
    public val endDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endDateTime
    /**
     * Unique identifier for the instance group.
     */
    public val instanceGroupId: kotlin.String? = builder.instanceGroupId
    /**
     * Target number of instances to run in the instance group.
     */
    public val instanceRequestCount: kotlin.Int? = builder.instanceRequestCount
    /**
     * Instance group role in the cluster
     */
    public val instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = builder.instanceRole
    /**
     * Actual count of running instances.
     */
    public val instanceRunningCount: kotlin.Int? = builder.instanceRunningCount
    /**
     * Amazon EC2 instance type.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * Details regarding the state of the instance group.
     */
    public val lastStateChangeReason: kotlin.String? = builder.lastStateChangeReason
    /**
     * Market type of the Amazon EC2 instances used to create a cluster node.
     */
    public val market: aws.sdk.kotlin.services.emr.model.MarketType? = builder.market
    /**
     * Friendly name for the instance group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The date/time the instance group was available to the cluster.
     */
    public val readyDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.readyDateTime
    /**
     * The date/time the instance group was started.
     */
    public val startDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startDateTime
    /**
     * State of instance group. The following values are no longer supported: STARTING, TERMINATED, and FAILED.
     */
    public val state: aws.sdk.kotlin.services.emr.model.InstanceGroupState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceGroupDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceGroupDetail(")
        append("bidPrice=$bidPrice,")
        append("creationDateTime=$creationDateTime,")
        append("customAmiId=$customAmiId,")
        append("endDateTime=$endDateTime,")
        append("instanceGroupId=$instanceGroupId,")
        append("instanceRequestCount=$instanceRequestCount,")
        append("instanceRole=$instanceRole,")
        append("instanceRunningCount=$instanceRunningCount,")
        append("instanceType=$instanceType,")
        append("lastStateChangeReason=$lastStateChangeReason,")
        append("market=$market,")
        append("name=$name,")
        append("readyDateTime=$readyDateTime,")
        append("startDateTime=$startDateTime,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bidPrice?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (endDateTime?.hashCode() ?: 0)
        result = 31 * result + (instanceGroupId?.hashCode() ?: 0)
        result = 31 * result + (instanceRequestCount ?: 0)
        result = 31 * result + (instanceRole?.hashCode() ?: 0)
        result = 31 * result + (instanceRunningCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lastStateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (market?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (readyDateTime?.hashCode() ?: 0)
        result = 31 * result + (startDateTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceGroupDetail

        if (bidPrice != other.bidPrice) return false
        if (creationDateTime != other.creationDateTime) return false
        if (customAmiId != other.customAmiId) return false
        if (endDateTime != other.endDateTime) return false
        if (instanceGroupId != other.instanceGroupId) return false
        if (instanceRequestCount != other.instanceRequestCount) return false
        if (instanceRole != other.instanceRole) return false
        if (instanceRunningCount != other.instanceRunningCount) return false
        if (instanceType != other.instanceType) return false
        if (lastStateChangeReason != other.lastStateChangeReason) return false
        if (market != other.market) return false
        if (name != other.name) return false
        if (readyDateTime != other.readyDateTime) return false
        if (startDateTime != other.startDateTime) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceGroupDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify `OnDemandPrice` to set the amount equal to the On-Demand price, or specify an amount in USD.
         */
        public var bidPrice: kotlin.String? = null
        /**
         * The date/time the instance group was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The custom AMI ID to use for the provisioned instance group.
         */
        public var customAmiId: kotlin.String? = null
        /**
         * The date/time the instance group was terminated.
         */
        public var endDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for the instance group.
         */
        public var instanceGroupId: kotlin.String? = null
        /**
         * Target number of instances to run in the instance group.
         */
        public var instanceRequestCount: kotlin.Int? = null
        /**
         * Instance group role in the cluster
         */
        public var instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = null
        /**
         * Actual count of running instances.
         */
        public var instanceRunningCount: kotlin.Int? = null
        /**
         * Amazon EC2 instance type.
         */
        public var instanceType: kotlin.String? = null
        /**
         * Details regarding the state of the instance group.
         */
        public var lastStateChangeReason: kotlin.String? = null
        /**
         * Market type of the Amazon EC2 instances used to create a cluster node.
         */
        public var market: aws.sdk.kotlin.services.emr.model.MarketType? = null
        /**
         * Friendly name for the instance group.
         */
        public var name: kotlin.String? = null
        /**
         * The date/time the instance group was available to the cluster.
         */
        public var readyDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date/time the instance group was started.
         */
        public var startDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * State of instance group. The following values are no longer supported: STARTING, TERMINATED, and FAILED.
         */
        public var state: aws.sdk.kotlin.services.emr.model.InstanceGroupState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceGroupDetail) : this() {
            this.bidPrice = x.bidPrice
            this.creationDateTime = x.creationDateTime
            this.customAmiId = x.customAmiId
            this.endDateTime = x.endDateTime
            this.instanceGroupId = x.instanceGroupId
            this.instanceRequestCount = x.instanceRequestCount
            this.instanceRole = x.instanceRole
            this.instanceRunningCount = x.instanceRunningCount
            this.instanceType = x.instanceType
            this.lastStateChangeReason = x.lastStateChangeReason
            this.market = x.market
            this.name = x.name
            this.readyDateTime = x.readyDateTime
            this.startDateTime = x.startDateTime
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceGroupDetail = InstanceGroupDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
