// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready to run jobs, and the time of termination.
 *
 * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions.
 */
public class InstanceFleetTimeline private constructor(builder: Builder) {
    /**
     * The time and date the instance fleet was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The time and date the instance fleet terminated.
     */
    public val endDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endDateTime
    /**
     * The time and date the instance fleet was ready to run jobs.
     */
    public val readyDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.readyDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceFleetTimeline(")
        append("creationDateTime=$creationDateTime,")
        append("endDateTime=$endDateTime,")
        append("readyDateTime=$readyDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (endDateTime?.hashCode() ?: 0)
        result = 31 * result + (readyDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceFleetTimeline

        if (creationDateTime != other.creationDateTime) return false
        if (endDateTime != other.endDateTime) return false
        if (readyDateTime != other.readyDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time and date the instance fleet was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time and date the instance fleet terminated.
         */
        public var endDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time and date the instance fleet was ready to run jobs.
         */
        public var readyDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline) : this() {
            this.creationDateTime = x.creationDateTime
            this.endDateTime = x.endDateTime
            this.readyDateTime = x.readyDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline = InstanceFleetTimeline(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
