// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents an Amazon EC2 instance provisioned as part of cluster.
 */
public class Instance private constructor(builder: Builder) {
    /**
     * The list of Amazon EBS volumes that are attached to this instance.
     */
    public val ebsVolumes: List<EbsVolume>? = builder.ebsVolumes
    /**
     * The unique identifier of the instance in Amazon EC2.
     */
    public val ec2InstanceId: kotlin.String? = builder.ec2InstanceId
    /**
     * The unique identifier for the instance in Amazon EMR.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The unique identifier of the instance fleet to which an Amazon EC2 instance belongs.
     */
    public val instanceFleetId: kotlin.String? = builder.instanceFleetId
    /**
     * The identifier of the instance group to which this instance belongs.
     */
    public val instanceGroupId: kotlin.String? = builder.instanceGroupId
    /**
     * The Amazon EC2 instance type, for example `m3.xlarge`.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The instance purchasing option. Valid values are `ON_DEMAND` or `SPOT`.
     */
    public val market: aws.sdk.kotlin.services.emr.model.MarketType? = builder.market
    /**
     * The private DNS name of the instance.
     */
    public val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * The private IP address of the instance.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The public DNS name of the instance.
     */
    public val publicDnsName: kotlin.String? = builder.publicDnsName
    /**
     * The public IP address of the instance.
     */
    public val publicIpAddress: kotlin.String? = builder.publicIpAddress
    /**
     * The current status of the instance.
     */
    public val status: aws.sdk.kotlin.services.emr.model.InstanceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("ebsVolumes=$ebsVolumes,")
        append("ec2InstanceId=$ec2InstanceId,")
        append("id=$id,")
        append("instanceFleetId=$instanceFleetId,")
        append("instanceGroupId=$instanceGroupId,")
        append("instanceType=$instanceType,")
        append("market=$market,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress,")
        append("publicDnsName=$publicDnsName,")
        append("publicIpAddress=$publicIpAddress,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ebsVolumes?.hashCode() ?: 0
        result = 31 * result + (ec2InstanceId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceFleetId?.hashCode() ?: 0)
        result = 31 * result + (instanceGroupId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (market?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (publicDnsName?.hashCode() ?: 0)
        result = 31 * result + (publicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (ebsVolumes != other.ebsVolumes) return false
        if (ec2InstanceId != other.ec2InstanceId) return false
        if (id != other.id) return false
        if (instanceFleetId != other.instanceFleetId) return false
        if (instanceGroupId != other.instanceGroupId) return false
        if (instanceType != other.instanceType) return false
        if (market != other.market) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (publicDnsName != other.publicDnsName) return false
        if (publicIpAddress != other.publicIpAddress) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Instance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of Amazon EBS volumes that are attached to this instance.
         */
        public var ebsVolumes: List<EbsVolume>? = null
        /**
         * The unique identifier of the instance in Amazon EC2.
         */
        public var ec2InstanceId: kotlin.String? = null
        /**
         * The unique identifier for the instance in Amazon EMR.
         */
        public var id: kotlin.String? = null
        /**
         * The unique identifier of the instance fleet to which an Amazon EC2 instance belongs.
         */
        public var instanceFleetId: kotlin.String? = null
        /**
         * The identifier of the instance group to which this instance belongs.
         */
        public var instanceGroupId: kotlin.String? = null
        /**
         * The Amazon EC2 instance type, for example `m3.xlarge`.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The instance purchasing option. Valid values are `ON_DEMAND` or `SPOT`.
         */
        public var market: aws.sdk.kotlin.services.emr.model.MarketType? = null
        /**
         * The private DNS name of the instance.
         */
        public var privateDnsName: kotlin.String? = null
        /**
         * The private IP address of the instance.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * The public DNS name of the instance.
         */
        public var publicDnsName: kotlin.String? = null
        /**
         * The public IP address of the instance.
         */
        public var publicIpAddress: kotlin.String? = null
        /**
         * The current status of the instance.
         */
        public var status: aws.sdk.kotlin.services.emr.model.InstanceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Instance) : this() {
            this.ebsVolumes = x.ebsVolumes
            this.ec2InstanceId = x.ec2InstanceId
            this.id = x.id
            this.instanceFleetId = x.instanceFleetId
            this.instanceGroupId = x.instanceGroupId
            this.instanceType = x.instanceType
            this.market = x.market
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
            this.publicDnsName = x.publicDnsName
            this.publicIpAddress = x.publicIpAddress
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Instance = Instance(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.emr.model.InstanceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.InstanceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
