// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of the step failure. The service attempts to detect the root cause for many common failures.
 */
public class FailureDetails private constructor(builder: Builder) {
    /**
     * The path to the log file where the step failure root cause was originally recorded.
     */
    public val logFile: kotlin.String? = builder.logFile
    /**
     * The descriptive message including the error the Amazon EMR service has identified as the cause of step failure. This is text from an error log that describes the root cause of the failure.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The reason for the step failure. In the case where the service cannot successfully determine the root cause of the failure, it returns "Unknown Error" as a reason.
     */
    public val reason: kotlin.String? = builder.reason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.FailureDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailureDetails(")
        append("logFile=$logFile,")
        append("message=$message,")
        append("reason=$reason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logFile?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailureDetails

        if (logFile != other.logFile) return false
        if (message != other.message) return false
        if (reason != other.reason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.FailureDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The path to the log file where the step failure root cause was originally recorded.
         */
        public var logFile: kotlin.String? = null
        /**
         * The descriptive message including the error the Amazon EMR service has identified as the cause of step failure. This is text from an error log that describes the root cause of the failure.
         */
        public var message: kotlin.String? = null
        /**
         * The reason for the step failure. In the case where the service cannot successfully determine the root cause of the failure, it returns "Unknown Error" as a reason.
         */
        public var reason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.FailureDetails) : this() {
            this.logFile = x.logFile
            this.message = x.message
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.FailureDetails = FailureDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
