// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the execution engine (cluster) to run the notebook and perform the notebook execution, for example, an Amazon EMR cluster.
 */
public class ExecutionEngineConfig private constructor(builder: Builder) {
    /**
     * The execution role ARN required for the notebook execution.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The unique identifier of the execution engine. For an Amazon EMR cluster, this is the cluster ID.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An optional unique ID of an Amazon EC2 security group to associate with the master instance of the Amazon EMR cluster for this notebook execution. For more information see [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html) in the *EMR Management Guide*.
     */
    public val masterInstanceSecurityGroupId: kotlin.String? = builder.masterInstanceSecurityGroupId
    /**
     * The type of execution engine. A value of `EMR` specifies an Amazon EMR cluster.
     */
    public val type: aws.sdk.kotlin.services.emr.model.ExecutionEngineType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionEngineConfig(")
        append("executionRoleArn=$executionRoleArn,")
        append("id=$id,")
        append("masterInstanceSecurityGroupId=$masterInstanceSecurityGroupId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionRoleArn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (masterInstanceSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionEngineConfig

        if (executionRoleArn != other.executionRoleArn) return false
        if (id != other.id) return false
        if (masterInstanceSecurityGroupId != other.masterInstanceSecurityGroupId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The execution role ARN required for the notebook execution.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The unique identifier of the execution engine. For an Amazon EMR cluster, this is the cluster ID.
         */
        public var id: kotlin.String? = null
        /**
         * An optional unique ID of an Amazon EC2 security group to associate with the master instance of the Amazon EMR cluster for this notebook execution. For more information see [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html) in the *EMR Management Guide*.
         */
        public var masterInstanceSecurityGroupId: kotlin.String? = null
        /**
         * The type of execution engine. A value of `EMR` specifies an Amazon EMR cluster.
         */
        public var type: aws.sdk.kotlin.services.emr.model.ExecutionEngineType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig) : this() {
            this.executionRoleArn = x.executionRoleArn
            this.id = x.id
            this.masterInstanceSecurityGroupId = x.masterInstanceSecurityGroupId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig = ExecutionEngineConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
