// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateStudioRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
     */
    public val authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = builder.authMode
    /**
     * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    public val defaultS3Location: kotlin.String? = builder.defaultS3Location
    /**
     * A detailed description of the Amazon EMR Studio.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `VpcId`.
     */
    public val engineSecurityGroupId: kotlin.String? = builder.engineSecurityGroupId
    /**
     * The ARN of the IAM Identity Center instance to create the Studio application.
     */
    public val idcInstanceArn: kotlin.String? = builder.idcInstanceArn
    /**
     * Specifies whether IAM Identity Center user assignment is `REQUIRED` or `OPTIONAL`. If the value is set to `REQUIRED`, users must be explicitly assigned to the Studio application to access the Studio.
     */
    public val idcUserAssignment: aws.sdk.kotlin.services.emr.model.IdcUserAssignment? = builder.idcUserAssignment
    /**
     * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    public val idpAuthUrl: kotlin.String? = builder.idpAuthUrl
    /**
     * The name that your identity provider (IdP) uses for its `RelayState` parameter. For example, `RelayState` or `TargetSource`. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The `RelayState` parameter differs by IdP.
     */
    public val idpRelayStateParameterName: kotlin.String? = builder.idpRelayStateParameterName
    /**
     * A descriptive name for the Amazon EMR Studio.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `VpcId`. Studio users can create a Workspace in any of the specified subnets.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A Boolean indicating whether to enable Trusted identity propagation for the Studio. The default value is `false`.
     */
    public val trustedIdentityPropagationEnabled: kotlin.Boolean? = builder.trustedIdentityPropagationEnabled
    /**
     * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a `UserRole` when you use IAM Identity Center authentication. The permissions attached to the `UserRole` can be scoped down for each user or group using session policies.
     */
    public val userRole: kotlin.String? = builder.userRole
    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    public val vpcId: kotlin.String? = builder.vpcId
    /**
     * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `VpcId`.
     */
    public val workspaceSecurityGroupId: kotlin.String? = builder.workspaceSecurityGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.CreateStudioRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStudioRequest(")
        append("authMode=$authMode,")
        append("defaultS3Location=$defaultS3Location,")
        append("description=$description,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("engineSecurityGroupId=$engineSecurityGroupId,")
        append("idcInstanceArn=$idcInstanceArn,")
        append("idcUserAssignment=$idcUserAssignment,")
        append("idpAuthUrl=$idpAuthUrl,")
        append("idpRelayStateParameterName=$idpRelayStateParameterName,")
        append("name=$name,")
        append("serviceRole=$serviceRole,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("trustedIdentityPropagationEnabled=$trustedIdentityPropagationEnabled,")
        append("userRole=$userRole,")
        append("vpcId=$vpcId,")
        append("workspaceSecurityGroupId=$workspaceSecurityGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authMode?.hashCode() ?: 0
        result = 31 * result + (defaultS3Location?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (engineSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (idcInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (idcUserAssignment?.hashCode() ?: 0)
        result = 31 * result + (idpAuthUrl?.hashCode() ?: 0)
        result = 31 * result + (idpRelayStateParameterName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trustedIdentityPropagationEnabled?.hashCode() ?: 0)
        result = 31 * result + (userRole?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (workspaceSecurityGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStudioRequest

        if (authMode != other.authMode) return false
        if (defaultS3Location != other.defaultS3Location) return false
        if (description != other.description) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (engineSecurityGroupId != other.engineSecurityGroupId) return false
        if (idcInstanceArn != other.idcInstanceArn) return false
        if (idcUserAssignment != other.idcUserAssignment) return false
        if (idpAuthUrl != other.idpAuthUrl) return false
        if (idpRelayStateParameterName != other.idpRelayStateParameterName) return false
        if (name != other.name) return false
        if (serviceRole != other.serviceRole) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (trustedIdentityPropagationEnabled != other.trustedIdentityPropagationEnabled) return false
        if (userRole != other.userRole) return false
        if (vpcId != other.vpcId) return false
        if (workspaceSecurityGroupId != other.workspaceSecurityGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.CreateStudioRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
         */
        public var authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = null
        /**
         * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         */
        public var defaultS3Location: kotlin.String? = null
        /**
         * A detailed description of the Amazon EMR Studio.
         */
        public var description: kotlin.String? = null
        /**
         * The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `VpcId`.
         */
        public var engineSecurityGroupId: kotlin.String? = null
        /**
         * The ARN of the IAM Identity Center instance to create the Studio application.
         */
        public var idcInstanceArn: kotlin.String? = null
        /**
         * Specifies whether IAM Identity Center user assignment is `REQUIRED` or `OPTIONAL`. If the value is set to `REQUIRED`, users must be explicitly assigned to the Studio application to access the Studio.
         */
        public var idcUserAssignment: aws.sdk.kotlin.services.emr.model.IdcUserAssignment? = null
        /**
         * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
         */
        public var idpAuthUrl: kotlin.String? = null
        /**
         * The name that your identity provider (IdP) uses for its `RelayState` parameter. For example, `RelayState` or `TargetSource`. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The `RelayState` parameter differs by IdP.
         */
        public var idpRelayStateParameterName: kotlin.String? = null
        /**
         * A descriptive name for the Amazon EMR Studio.
         */
        public var name: kotlin.String? = null
        /**
         * The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `VpcId`. Studio users can create a Workspace in any of the specified subnets.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.
         */
        public var tags: List<Tag>? = null
        /**
         * A Boolean indicating whether to enable Trusted identity propagation for the Studio. The default value is `false`.
         */
        public var trustedIdentityPropagationEnabled: kotlin.Boolean? = null
        /**
         * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a `UserRole` when you use IAM Identity Center authentication. The permissions attached to the `UserRole` can be scoped down for each user or group using session policies.
         */
        public var userRole: kotlin.String? = null
        /**
         * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
         */
        public var vpcId: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `VpcId`.
         */
        public var workspaceSecurityGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.CreateStudioRequest) : this() {
            this.authMode = x.authMode
            this.defaultS3Location = x.defaultS3Location
            this.description = x.description
            this.encryptionKeyArn = x.encryptionKeyArn
            this.engineSecurityGroupId = x.engineSecurityGroupId
            this.idcInstanceArn = x.idcInstanceArn
            this.idcUserAssignment = x.idcUserAssignment
            this.idpAuthUrl = x.idpAuthUrl
            this.idpRelayStateParameterName = x.idpRelayStateParameterName
            this.name = x.name
            this.serviceRole = x.serviceRole
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.trustedIdentityPropagationEnabled = x.trustedIdentityPropagationEnabled
            this.userRole = x.userRole
            this.vpcId = x.vpcId
            this.workspaceSecurityGroupId = x.workspaceSecurityGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.CreateStudioRequest = CreateStudioRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
