// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster can not be above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
 */
public class ComputeLimits private constructor(builder: Builder) {
    /**
     * The upper boundary of Amazon EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    public val maximumCapacityUnits: kotlin.Int? = builder.maximumCapacityUnits
    /**
     * The upper boundary of Amazon EC2 units for core node type in a cluster. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
     */
    public val maximumCoreCapacityUnits: kotlin.Int? = builder.maximumCoreCapacityUnits
    /**
     * The upper boundary of On-Demand Amazon EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot Instances.
     */
    public val maximumOnDemandCapacityUnits: kotlin.Int? = builder.maximumOnDemandCapacityUnits
    /**
     * The lower boundary of Amazon EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    public val minimumCapacityUnits: kotlin.Int? = builder.minimumCapacityUnits
    /**
     * The unit type used for specifying a managed scaling policy.
     */
    public val unitType: aws.sdk.kotlin.services.emr.model.ComputeLimitsUnitType? = builder.unitType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ComputeLimits = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeLimits(")
        append("maximumCapacityUnits=$maximumCapacityUnits,")
        append("maximumCoreCapacityUnits=$maximumCoreCapacityUnits,")
        append("maximumOnDemandCapacityUnits=$maximumOnDemandCapacityUnits,")
        append("minimumCapacityUnits=$minimumCapacityUnits,")
        append("unitType=$unitType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumCapacityUnits ?: 0
        result = 31 * result + (maximumCoreCapacityUnits ?: 0)
        result = 31 * result + (maximumOnDemandCapacityUnits ?: 0)
        result = 31 * result + (minimumCapacityUnits ?: 0)
        result = 31 * result + (unitType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeLimits

        if (maximumCapacityUnits != other.maximumCapacityUnits) return false
        if (maximumCoreCapacityUnits != other.maximumCoreCapacityUnits) return false
        if (maximumOnDemandCapacityUnits != other.maximumOnDemandCapacityUnits) return false
        if (minimumCapacityUnits != other.minimumCapacityUnits) return false
        if (unitType != other.unitType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ComputeLimits = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The upper boundary of Amazon EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         */
        public var maximumCapacityUnits: kotlin.Int? = null
        /**
         * The upper boundary of Amazon EC2 units for core node type in a cluster. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
         */
        public var maximumCoreCapacityUnits: kotlin.Int? = null
        /**
         * The upper boundary of On-Demand Amazon EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot Instances.
         */
        public var maximumOnDemandCapacityUnits: kotlin.Int? = null
        /**
         * The lower boundary of Amazon EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         */
        public var minimumCapacityUnits: kotlin.Int? = null
        /**
         * The unit type used for specifying a managed scaling policy.
         */
        public var unitType: aws.sdk.kotlin.services.emr.model.ComputeLimitsUnitType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ComputeLimits) : this() {
            this.maximumCapacityUnits = x.maximumCapacityUnits
            this.maximumCoreCapacityUnits = x.maximumCoreCapacityUnits
            this.maximumOnDemandCapacityUnits = x.maximumOnDemandCapacityUnits
            this.minimumCapacityUnits = x.minimumCapacityUnits
            this.unitType = x.unitType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ComputeLimits = ComputeLimits(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
