// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The summary description of the cluster.
 */
public class ClusterSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name of the cluster.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The unique identifier for the cluster.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the cluster.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one time for every hour an m1.small instance runs. Larger instances are weighted more, so an Amazon EC2 instance that is roughly four times more expensive would result in the normalized instance hours being incremented by four. This result is only an approximation and does not reflect the actual billing rate.
     */
    public val normalizedInstanceHours: kotlin.Int? = builder.normalizedInstanceHours
    /**
     * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The details about the current status of the cluster.
     */
    public val status: aws.sdk.kotlin.services.emr.model.ClusterStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ClusterSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterSummary(")
        append("clusterArn=$clusterArn,")
        append("id=$id,")
        append("name=$name,")
        append("normalizedInstanceHours=$normalizedInstanceHours,")
        append("outpostArn=$outpostArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (normalizedInstanceHours ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterSummary

        if (clusterArn != other.clusterArn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (normalizedInstanceHours != other.normalizedInstanceHours) return false
        if (outpostArn != other.outpostArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ClusterSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name of the cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The unique identifier for the cluster.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the cluster.
         */
        public var name: kotlin.String? = null
        /**
         * An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one time for every hour an m1.small instance runs. Larger instances are weighted more, so an Amazon EC2 instance that is roughly four times more expensive would result in the normalized instance hours being incremented by four. This result is only an approximation and does not reflect the actual billing rate.
         */
        public var normalizedInstanceHours: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The details about the current status of the cluster.
         */
        public var status: aws.sdk.kotlin.services.emr.model.ClusterStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ClusterSummary) : this() {
            this.clusterArn = x.clusterArn
            this.id = x.id
            this.name = x.name
            this.normalizedInstanceHours = x.normalizedInstanceHours
            this.outpostArn = x.outpostArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ClusterSummary = ClusterSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ClusterStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.emr.model.ClusterStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.ClusterStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
