// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties that describe the Amazon Web Services principal that created the `BlockPublicAccessConfiguration` using the `PutBlockPublicAccessConfiguration` action as well as the date and time that the configuration was created. Each time a configuration for block public access is updated, Amazon EMR updates this metadata.
 */
public class BlockPublicAccessConfigurationMetadata private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name that created or last modified the configuration.
     */
    public val createdByArn: kotlin.String? = builder.createdByArn
    /**
     * The date and time that the configuration was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfigurationMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlockPublicAccessConfigurationMetadata(")
        append("createdByArn=$createdByArn,")
        append("creationDateTime=$creationDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdByArn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlockPublicAccessConfigurationMetadata

        if (createdByArn != other.createdByArn) return false
        if (creationDateTime != other.creationDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfigurationMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name that created or last modified the configuration.
         */
        public var createdByArn: kotlin.String? = null
        /**
         * The date and time that the configuration was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfigurationMetadata) : this() {
            this.createdByArn = x.createdByArn
            this.creationDateTime = x.creationDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfigurationMetadata = BlockPublicAccessConfigurationMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
