// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. An automatic scaling policy defines how an instance group dynamically adds and terminates Amazon EC2 instances in response to the value of a CloudWatch metric. See PutAutoScalingPolicy.
 */
public class AutoScalingPolicy private constructor(builder: Builder) {
    /**
     * The upper and lower Amazon EC2 instance limits for an automatic scaling policy. Automatic scaling activity will not cause an instance group to grow above or below these limits.
     */
    public val constraints: aws.sdk.kotlin.services.emr.model.ScalingConstraints? = builder.constraints
    /**
     * The scale-in and scale-out rules that comprise the automatic scaling policy.
     */
    public val rules: List<ScalingRule>? = builder.rules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.AutoScalingPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingPolicy(")
        append("constraints=$constraints,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = constraints?.hashCode() ?: 0
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingPolicy

        if (constraints != other.constraints) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.AutoScalingPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The upper and lower Amazon EC2 instance limits for an automatic scaling policy. Automatic scaling activity will not cause an instance group to grow above or below these limits.
         */
        public var constraints: aws.sdk.kotlin.services.emr.model.ScalingConstraints? = null
        /**
         * The scale-in and scale-out rules that comprise the automatic scaling policy.
         */
        public var rules: List<ScalingRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.AutoScalingPolicy) : this() {
            this.constraints = x.constraints
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.AutoScalingPolicy = AutoScalingPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ScalingConstraints] inside the given [block]
         */
        public fun constraints(block: aws.sdk.kotlin.services.emr.model.ScalingConstraints.Builder.() -> kotlin.Unit) {
            this.constraints = aws.sdk.kotlin.services.emr.model.ScalingConstraints.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
