// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.serde

import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.InstanceGroup
import aws.sdk.kotlin.services.emr.model.ListInstanceGroupsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListInstanceGroupsOperationDeserializer: HttpDeserialize<ListInstanceGroupsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListInstanceGroupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListInstanceGroupsError(context, call)
        }
        val builder = ListInstanceGroupsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListInstanceGroupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListInstanceGroupsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListInstanceGroupsOperationBody(builder: ListInstanceGroupsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCEGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InstanceGroups"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCEGROUPS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCEGROUPS_DESCRIPTOR.index -> builder.instanceGroups =
                    deserializer.deserializeList(INSTANCEGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
