// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.serde

import aws.sdk.kotlin.services.emr.model.DescribeReleaseLabelResponse
import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.OsRelease
import aws.sdk.kotlin.services.emr.model.SimplifiedApplication
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeReleaseLabelOperationDeserializer: HttpDeserialize<DescribeReleaseLabelResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeReleaseLabelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeReleaseLabelError(context, call)
        }
        val builder = DescribeReleaseLabelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReleaseLabelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeReleaseLabelError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReleaseLabelOperationBody(builder: DescribeReleaseLabelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Applications"))
    val AVAILABLEOSRELEASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AvailableOSReleases"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RELEASELABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReleaseLabel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONS_DESCRIPTOR)
        field(AVAILABLEOSRELEASES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RELEASELABEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONS_DESCRIPTOR.index -> builder.applications =
                    deserializer.deserializeList(APPLICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<SimplifiedApplication>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSimplifiedApplicationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AVAILABLEOSRELEASES_DESCRIPTOR.index -> builder.availableOsReleases =
                    deserializer.deserializeList(AVAILABLEOSRELEASES_DESCRIPTOR) {
                        val col0 = mutableListOf<OsRelease>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOsReleaseDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RELEASELABEL_DESCRIPTOR.index -> builder.releaseLabel = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
