// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster.
 */
public class VolumeSpecification private constructor(builder: Builder) {
    /**
     * The number of I/O operations per second (IOPS) that the volume supports.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
     */
    public val sizeInGb: kotlin.Int? = builder.sizeInGb
    /**
     * The throughput, in mebibyte per second (MiB/s). This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.
     */
    public val throughput: kotlin.Int? = builder.throughput
    /**
     * The volume type. Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
     */
    public val volumeType: kotlin.String? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.VolumeSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeSpecification(")
        append("iops=$iops,")
        append("sizeInGb=$sizeInGb,")
        append("throughput=$throughput,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iops ?: 0
        result = 31 * result + (sizeInGb ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeSpecification

        if (iops != other.iops) return false
        if (sizeInGb != other.sizeInGb) return false
        if (throughput != other.throughput) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.VolumeSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         */
        public var iops: kotlin.Int? = null
        /**
         * The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
         */
        public var sizeInGb: kotlin.Int? = null
        /**
         * The throughput, in mebibyte per second (MiB/s). This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.
         */
        public var throughput: kotlin.Int? = null
        /**
         * The volume type. Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
         */
        public var volumeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.VolumeSpecification) : this() {
            this.iops = x.iops
            this.sizeInGb = x.sizeInGb
            this.throughput = x.throughput
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.VolumeSpecification = VolumeSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
