// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for an Amazon EMR Studio session mapping including creation time, user or group ID, Studio ID, and so on.
 */
public class SessionMappingDetail private constructor(builder: Builder) {
    /**
     * The time the session mapping was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The globally unique identifier (GUID) of the user or group.
     */
    public val identityId: kotlin.String? = builder.identityId
    /**
     * The name of the user or group. For more information, see [UserName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName) and [DisplayName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName) in the *IAM Identity Center Identity Store API Reference*.
     */
    public val identityName: kotlin.String? = builder.identityName
    /**
     * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
     */
    public val identityType: aws.sdk.kotlin.services.emr.model.IdentityType? = builder.identityType
    /**
     * The time the session mapping was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the session policy associated with the user or group.
     */
    public val sessionPolicyArn: kotlin.String? = builder.sessionPolicyArn
    /**
     * The ID of the Amazon EMR Studio.
     */
    public val studioId: kotlin.String? = builder.studioId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.SessionMappingDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionMappingDetail(")
        append("creationTime=$creationTime,")
        append("identityId=$identityId,")
        append("identityName=$identityName,")
        append("identityType=$identityType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("sessionPolicyArn=$sessionPolicyArn,")
        append("studioId=$studioId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (identityName?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (sessionPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (studioId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionMappingDetail

        if (creationTime != other.creationTime) return false
        if (identityId != other.identityId) return false
        if (identityName != other.identityName) return false
        if (identityType != other.identityType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (sessionPolicyArn != other.sessionPolicyArn) return false
        if (studioId != other.studioId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.SessionMappingDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the session mapping was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The globally unique identifier (GUID) of the user or group.
         */
        public var identityId: kotlin.String? = null
        /**
         * The name of the user or group. For more information, see [UserName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName) and [DisplayName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName) in the *IAM Identity Center Identity Store API Reference*.
         */
        public var identityName: kotlin.String? = null
        /**
         * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
         */
        public var identityType: aws.sdk.kotlin.services.emr.model.IdentityType? = null
        /**
         * The time the session mapping was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the session policy associated with the user or group.
         */
        public var sessionPolicyArn: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio.
         */
        public var studioId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.SessionMappingDetail) : this() {
            this.creationTime = x.creationTime
            this.identityId = x.identityId
            this.identityName = x.identityName
            this.identityType = x.identityType
            this.lastModifiedTime = x.lastModifiedTime
            this.sessionPolicyArn = x.sessionPolicyArn
            this.studioId = x.studioId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.SessionMappingDetail = SessionMappingDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
