// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * A scale-in or scale-out rule that defines scaling activity, including the CloudWatch metric alarm that triggers activity, how Amazon EC2 instances are added or removed, and the periodicity of adjustments. The automatic scaling policy for an instance group can comprise one or more automatic scaling rules.
 */
public class ScalingRule private constructor(builder: Builder) {
    /**
     * The conditions that trigger an automatic scaling activity.
     */
    public val action: aws.sdk.kotlin.services.emr.model.ScalingAction? = builder.action
    /**
     * A friendly, more verbose description of the automatic scaling rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name used to identify an automatic scaling rule. Rule names must be unique within a scaling policy.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
     */
    public val trigger: aws.sdk.kotlin.services.emr.model.ScalingTrigger? = builder.trigger

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ScalingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingRule(")
        append("action=$action,")
        append("description=$description,")
        append("name=$name,")
        append("trigger=$trigger")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (trigger?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingRule

        if (action != other.action) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (trigger != other.trigger) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ScalingRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The conditions that trigger an automatic scaling activity.
         */
        public var action: aws.sdk.kotlin.services.emr.model.ScalingAction? = null
        /**
         * A friendly, more verbose description of the automatic scaling rule.
         */
        public var description: kotlin.String? = null
        /**
         * The name used to identify an automatic scaling rule. Rule names must be unique within a scaling policy.
         */
        public var name: kotlin.String? = null
        /**
         * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         */
        public var trigger: aws.sdk.kotlin.services.emr.model.ScalingTrigger? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ScalingRule) : this() {
            this.action = x.action
            this.description = x.description
            this.name = x.name
            this.trigger = x.trigger
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ScalingRule = ScalingRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ScalingAction] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.emr.model.ScalingAction.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.emr.model.ScalingAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ScalingTrigger] inside the given [block]
         */
        public fun trigger(block: aws.sdk.kotlin.services.emr.model.ScalingTrigger.Builder.() -> kotlin.Unit) {
            this.trigger = aws.sdk.kotlin.services.emr.model.ScalingTrigger.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
