// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see [Use Kerberos Authentication](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html) in the *Amazon EMR Management Guide*.
 */
public class KerberosAttributes private constructor(builder: Builder) {
    /**
     * The Active Directory password for `ADDomainJoinUser`.
     */
    public val adDomainJoinPassword: kotlin.String? = builder.adDomainJoinPassword
    /**
     * Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain.
     */
    public val adDomainJoinUser: kotlin.String? = builder.adDomainJoinUser
    /**
     * Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms.
     */
    public val crossRealmTrustPrincipalPassword: kotlin.String? = builder.crossRealmTrustPrincipalPassword
    /**
     * The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
     */
    public val kdcAdminPassword: kotlin.String? = builder.kdcAdminPassword
    /**
     * The name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`.
     */
    public val realm: kotlin.String? = builder.realm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.KerberosAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KerberosAttributes(")
        append("adDomainJoinPassword=$adDomainJoinPassword,")
        append("adDomainJoinUser=$adDomainJoinUser,")
        append("crossRealmTrustPrincipalPassword=$crossRealmTrustPrincipalPassword,")
        append("kdcAdminPassword=$kdcAdminPassword,")
        append("realm=$realm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adDomainJoinPassword?.hashCode() ?: 0
        result = 31 * result + (adDomainJoinUser?.hashCode() ?: 0)
        result = 31 * result + (crossRealmTrustPrincipalPassword?.hashCode() ?: 0)
        result = 31 * result + (kdcAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (realm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KerberosAttributes

        if (adDomainJoinPassword != other.adDomainJoinPassword) return false
        if (adDomainJoinUser != other.adDomainJoinUser) return false
        if (crossRealmTrustPrincipalPassword != other.crossRealmTrustPrincipalPassword) return false
        if (kdcAdminPassword != other.kdcAdminPassword) return false
        if (realm != other.realm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.KerberosAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Active Directory password for `ADDomainJoinUser`.
         */
        public var adDomainJoinPassword: kotlin.String? = null
        /**
         * Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain.
         */
        public var adDomainJoinUser: kotlin.String? = null
        /**
         * Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms.
         */
        public var crossRealmTrustPrincipalPassword: kotlin.String? = null
        /**
         * The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
         */
        public var kdcAdminPassword: kotlin.String? = null
        /**
         * The name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`.
         */
        public var realm: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.KerberosAttributes) : this() {
            this.adDomainJoinPassword = x.adDomainJoinPassword
            this.adDomainJoinUser = x.adDomainJoinUser
            this.crossRealmTrustPrincipalPassword = x.crossRealmTrustPrincipalPassword
            this.kdcAdminPassword = x.kdcAdminPassword
            this.realm = x.realm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.KerberosAttributes = KerberosAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
