// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Describes an instance fleet, which is a group of Amazon EC2 instances that host a particular node type (master, core, or task) in an Amazon EMR cluster. Instance fleets can consist of a mix of instance types and On-Demand and Spot Instances, which are provisioned to meet a defined target capacity.
 *
 * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions.
 */
public class InstanceFleet private constructor(builder: Builder) {
    /**
     * The unique identifier of the instance fleet.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The node type that the instance fleet hosts. Valid values are MASTER, CORE, or TASK.
     */
    public val instanceFleetType: aws.sdk.kotlin.services.emr.model.InstanceFleetType? = builder.instanceFleetType
    /**
     * An array of specifications for the instance types that comprise an instance fleet.
     */
    public val instanceTypeSpecifications: List<InstanceTypeSpecification>? = builder.instanceTypeSpecifications
    /**
     * Describes the launch specification for an instance fleet.
     */
    public val launchSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications? = builder.launchSpecifications
    /**
     * A friendly name for the instance fleet.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The number of On-Demand units that have been provisioned for the instance fleet to fulfill `TargetOnDemandCapacity`. This provisioned capacity might be less than or greater than `TargetOnDemandCapacity`.
     */
    public val provisionedOnDemandCapacity: kotlin.Int? = builder.provisionedOnDemandCapacity
    /**
     * The number of Spot units that have been provisioned for this instance fleet to fulfill `TargetSpotCapacity`. This provisioned capacity might be less than or greater than `TargetSpotCapacity`.
     */
    public val provisionedSpotCapacity: kotlin.Int? = builder.provisionedSpotCapacity
    /**
     * The resize specification for the instance fleet.
     */
    public val resizeSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications? = builder.resizeSpecifications
    /**
     * The current status of the instance fleet.
     */
    public val status: aws.sdk.kotlin.services.emr.model.InstanceFleetStatus? = builder.status
    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When an On-Demand Instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedOnDemandCapacity to determine the Spot capacity units that have been provisioned for the instance fleet.
     *
     * If not specified or set to 0, only Spot Instances are provisioned for the instance fleet using `TargetSpotCapacity`. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
     */
    public val targetOnDemandCapacity: kotlin.Int? = builder.targetOnDemandCapacity
    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot Instances to provision. When the instance fleet launches, Amazon EMR tries to provision Spot Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When a Spot instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedSpotCapacity to determine the Spot capacity units that have been provisioned for the instance fleet.
     *
     * If not specified or set to 0, only On-Demand Instances are provisioned for the instance fleet. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
     */
    public val targetSpotCapacity: kotlin.Int? = builder.targetSpotCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceFleet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceFleet(")
        append("id=$id,")
        append("instanceFleetType=$instanceFleetType,")
        append("instanceTypeSpecifications=$instanceTypeSpecifications,")
        append("launchSpecifications=$launchSpecifications,")
        append("name=$name,")
        append("provisionedOnDemandCapacity=$provisionedOnDemandCapacity,")
        append("provisionedSpotCapacity=$provisionedSpotCapacity,")
        append("resizeSpecifications=$resizeSpecifications,")
        append("status=$status,")
        append("targetOnDemandCapacity=$targetOnDemandCapacity,")
        append("targetSpotCapacity=$targetSpotCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (instanceFleetType?.hashCode() ?: 0)
        result = 31 * result + (instanceTypeSpecifications?.hashCode() ?: 0)
        result = 31 * result + (launchSpecifications?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (provisionedOnDemandCapacity ?: 0)
        result = 31 * result + (provisionedSpotCapacity ?: 0)
        result = 31 * result + (resizeSpecifications?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetOnDemandCapacity ?: 0)
        result = 31 * result + (targetSpotCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceFleet

        if (id != other.id) return false
        if (instanceFleetType != other.instanceFleetType) return false
        if (instanceTypeSpecifications != other.instanceTypeSpecifications) return false
        if (launchSpecifications != other.launchSpecifications) return false
        if (name != other.name) return false
        if (provisionedOnDemandCapacity != other.provisionedOnDemandCapacity) return false
        if (provisionedSpotCapacity != other.provisionedSpotCapacity) return false
        if (resizeSpecifications != other.resizeSpecifications) return false
        if (status != other.status) return false
        if (targetOnDemandCapacity != other.targetOnDemandCapacity) return false
        if (targetSpotCapacity != other.targetSpotCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceFleet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the instance fleet.
         */
        public var id: kotlin.String? = null
        /**
         * The node type that the instance fleet hosts. Valid values are MASTER, CORE, or TASK.
         */
        public var instanceFleetType: aws.sdk.kotlin.services.emr.model.InstanceFleetType? = null
        /**
         * An array of specifications for the instance types that comprise an instance fleet.
         */
        public var instanceTypeSpecifications: List<InstanceTypeSpecification>? = null
        /**
         * Describes the launch specification for an instance fleet.
         */
        public var launchSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications? = null
        /**
         * A friendly name for the instance fleet.
         */
        public var name: kotlin.String? = null
        /**
         * The number of On-Demand units that have been provisioned for the instance fleet to fulfill `TargetOnDemandCapacity`. This provisioned capacity might be less than or greater than `TargetOnDemandCapacity`.
         */
        public var provisionedOnDemandCapacity: kotlin.Int? = null
        /**
         * The number of Spot units that have been provisioned for this instance fleet to fulfill `TargetSpotCapacity`. This provisioned capacity might be less than or greater than `TargetSpotCapacity`.
         */
        public var provisionedSpotCapacity: kotlin.Int? = null
        /**
         * The resize specification for the instance fleet.
         */
        public var resizeSpecifications: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications? = null
        /**
         * The current status of the instance fleet.
         */
        public var status: aws.sdk.kotlin.services.emr.model.InstanceFleetStatus? = null
        /**
         * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When an On-Demand Instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedOnDemandCapacity to determine the Spot capacity units that have been provisioned for the instance fleet.
         *
         * If not specified or set to 0, only Spot Instances are provisioned for the instance fleet using `TargetSpotCapacity`. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
         */
        public var targetOnDemandCapacity: kotlin.Int? = null
        /**
         * The target capacity of Spot units for the instance fleet, which determines how many Spot Instances to provision. When the instance fleet launches, Amazon EMR tries to provision Spot Instances as specified by InstanceTypeConfig. Each instance configuration has a specified `WeightedCapacity`. When a Spot instance is provisioned, the `WeightedCapacity` units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a `WeightedCapacity` of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedSpotCapacity to determine the Spot capacity units that have been provisioned for the instance fleet.
         *
         * If not specified or set to 0, only On-Demand Instances are provisioned for the instance fleet. At least one of `TargetSpotCapacity` and `TargetOnDemandCapacity` should be greater than 0. For a master instance fleet, only one of `TargetSpotCapacity` and `TargetOnDemandCapacity` can be specified, and its value must be 1.
         */
        public var targetSpotCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceFleet) : this() {
            this.id = x.id
            this.instanceFleetType = x.instanceFleetType
            this.instanceTypeSpecifications = x.instanceTypeSpecifications
            this.launchSpecifications = x.launchSpecifications
            this.name = x.name
            this.provisionedOnDemandCapacity = x.provisionedOnDemandCapacity
            this.provisionedSpotCapacity = x.provisionedSpotCapacity
            this.resizeSpecifications = x.resizeSpecifications
            this.status = x.status
            this.targetOnDemandCapacity = x.targetOnDemandCapacity
            this.targetSpotCapacity = x.targetSpotCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceFleet = InstanceFleet(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications] inside the given [block]
         */
        public fun launchSpecifications(block: aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications.Builder.() -> kotlin.Unit) {
            this.launchSpecifications = aws.sdk.kotlin.services.emr.model.InstanceFleetProvisioningSpecifications.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications] inside the given [block]
         */
        public fun resizeSpecifications(block: aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications.Builder.() -> kotlin.Unit) {
            this.resizeSpecifications = aws.sdk.kotlin.services.emr.model.InstanceFleetResizingSpecifications.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.emr.model.InstanceFleetStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.InstanceFleetStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
