// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.serde

import aws.sdk.kotlin.services.emr.model.Credentials
import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.GetClusterSessionCredentialsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetClusterSessionCredentialsOperationDeserializer: HttpDeserialize<GetClusterSessionCredentialsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetClusterSessionCredentialsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetClusterSessionCredentialsError(context, call)
        }
        val builder = GetClusterSessionCredentialsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetClusterSessionCredentialsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetClusterSessionCredentialsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetClusterSessionCredentialsOperationBody(builder: GetClusterSessionCredentialsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Credentials"))
    val EXPIRESAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpiresAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIALS_DESCRIPTOR)
        field(EXPIRESAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeCredentialsDocument(deserializer)
                EXPIRESAT_DESCRIPTOR.index -> builder.expiresAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
