// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * An instance type that the specified Amazon EMR release supports.
 */
public class SupportedInstanceType private constructor(builder: Builder) {
    /**
     * The CPU architecture, for example `X86_64` or `AARCH64`.
     */
    public val architecture: kotlin.String? = builder.architecture
    /**
     * Indicates whether the `SupportedInstanceType` supports Amazon EBS optimization.
     */
    public val ebsOptimizedAvailable: kotlin.Boolean? = builder.ebsOptimizedAvailable
    /**
     * Indicates whether the `SupportedInstanceType` uses Amazon EBS optimization by default.
     */
    public val ebsOptimizedByDefault: kotlin.Boolean? = builder.ebsOptimizedByDefault
    /**
     * Indicates whether the `SupportedInstanceType` only supports Amazon EBS.
     */
    public val ebsStorageOnly: kotlin.Boolean? = builder.ebsStorageOnly
    /**
     * The Amazon EC2 family and generation for the `SupportedInstanceType`.
     */
    public val instanceFamilyId: kotlin.String? = builder.instanceFamilyId
    /**
     * Indicates whether the `SupportedInstanceType` only supports 64-bit architecture.
     */
    public val is64BitsOnly: kotlin.Boolean? = builder.is64BitsOnly
    /**
     * The amount of memory that is available to Amazon EMR from the `SupportedInstanceType`. The kernel and hypervisor software consume some memory, so this value might be lower than the overall memory for the instance type.
     */
    public val memoryGb: kotlin.Float? = builder.memoryGb
    /**
     * Number of disks for the `SupportedInstanceType`. This value is `0` for Amazon EBS-only instance types.
     */
    public val numberOfDisks: kotlin.Int? = builder.numberOfDisks
    /**
     * `StorageGB` represents the storage capacity of the `SupportedInstanceType`. This value is `0` for Amazon EBS-only instance types.
     */
    public val storageGb: kotlin.Int? = builder.storageGb
    /**
     * The [Amazon EC2 instance type](http://aws.amazon.com/ec2/instance-types/), for example `m5.xlarge`, of the `SupportedInstanceType`.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The number of vCPUs available for the `SupportedInstanceType`.
     */
    public val vcpu: kotlin.Int? = builder.vcpu

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.SupportedInstanceType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SupportedInstanceType(")
        append("architecture=$architecture,")
        append("ebsOptimizedAvailable=$ebsOptimizedAvailable,")
        append("ebsOptimizedByDefault=$ebsOptimizedByDefault,")
        append("ebsStorageOnly=$ebsStorageOnly,")
        append("instanceFamilyId=$instanceFamilyId,")
        append("is64BitsOnly=$is64BitsOnly,")
        append("memoryGb=$memoryGb,")
        append("numberOfDisks=$numberOfDisks,")
        append("storageGb=$storageGb,")
        append("type=$type,")
        append("vcpu=$vcpu")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (ebsOptimizedAvailable?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimizedByDefault?.hashCode() ?: 0)
        result = 31 * result + (ebsStorageOnly?.hashCode() ?: 0)
        result = 31 * result + (instanceFamilyId?.hashCode() ?: 0)
        result = 31 * result + (is64BitsOnly?.hashCode() ?: 0)
        result = 31 * result + (memoryGb?.hashCode() ?: 0)
        result = 31 * result + (numberOfDisks ?: 0)
        result = 31 * result + (storageGb ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vcpu ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SupportedInstanceType

        if (architecture != other.architecture) return false
        if (ebsOptimizedAvailable != other.ebsOptimizedAvailable) return false
        if (ebsOptimizedByDefault != other.ebsOptimizedByDefault) return false
        if (ebsStorageOnly != other.ebsStorageOnly) return false
        if (instanceFamilyId != other.instanceFamilyId) return false
        if (is64BitsOnly != other.is64BitsOnly) return false
        if (memoryGb != other.memoryGb) return false
        if (numberOfDisks != other.numberOfDisks) return false
        if (storageGb != other.storageGb) return false
        if (type != other.type) return false
        if (vcpu != other.vcpu) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.SupportedInstanceType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CPU architecture, for example `X86_64` or `AARCH64`.
         */
        public var architecture: kotlin.String? = null
        /**
         * Indicates whether the `SupportedInstanceType` supports Amazon EBS optimization.
         */
        public var ebsOptimizedAvailable: kotlin.Boolean? = null
        /**
         * Indicates whether the `SupportedInstanceType` uses Amazon EBS optimization by default.
         */
        public var ebsOptimizedByDefault: kotlin.Boolean? = null
        /**
         * Indicates whether the `SupportedInstanceType` only supports Amazon EBS.
         */
        public var ebsStorageOnly: kotlin.Boolean? = null
        /**
         * The Amazon EC2 family and generation for the `SupportedInstanceType`.
         */
        public var instanceFamilyId: kotlin.String? = null
        /**
         * Indicates whether the `SupportedInstanceType` only supports 64-bit architecture.
         */
        public var is64BitsOnly: kotlin.Boolean? = null
        /**
         * The amount of memory that is available to Amazon EMR from the `SupportedInstanceType`. The kernel and hypervisor software consume some memory, so this value might be lower than the overall memory for the instance type.
         */
        public var memoryGb: kotlin.Float? = null
        /**
         * Number of disks for the `SupportedInstanceType`. This value is `0` for Amazon EBS-only instance types.
         */
        public var numberOfDisks: kotlin.Int? = null
        /**
         * `StorageGB` represents the storage capacity of the `SupportedInstanceType`. This value is `0` for Amazon EBS-only instance types.
         */
        public var storageGb: kotlin.Int? = null
        /**
         * The [Amazon EC2 instance type](http://aws.amazon.com/ec2/instance-types/), for example `m5.xlarge`, of the `SupportedInstanceType`.
         */
        public var type: kotlin.String? = null
        /**
         * The number of vCPUs available for the `SupportedInstanceType`.
         */
        public var vcpu: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.SupportedInstanceType) : this() {
            this.architecture = x.architecture
            this.ebsOptimizedAvailable = x.ebsOptimizedAvailable
            this.ebsOptimizedByDefault = x.ebsOptimizedByDefault
            this.ebsStorageOnly = x.ebsStorageOnly
            this.instanceFamilyId = x.instanceFamilyId
            this.is64BitsOnly = x.is64BitsOnly
            this.memoryGb = x.memoryGb
            this.numberOfDisks = x.numberOfDisks
            this.storageGb = x.storageGb
            this.type = x.type
            this.vcpu = x.vcpu
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.SupportedInstanceType = SupportedInstanceType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
