// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



public class PutBlockPublicAccessConfigurationRequest private constructor(builder: Builder) {
    /**
     * A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using `PermittedPublicSecurityGroupRuleRanges` in the `BlockPublicAccessConfiguration`. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating `BlockPublicSecurityGroupRules` to remove the exception.
     *
     * For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an Amazon EMR cluster in a Region before this date, block public access is enabled by default in that Region.
     */
    public val blockPublicAccessConfiguration: aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration? = builder.blockPublicAccessConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.PutBlockPublicAccessConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBlockPublicAccessConfigurationRequest(")
        append("blockPublicAccessConfiguration=$blockPublicAccessConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockPublicAccessConfiguration?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBlockPublicAccessConfigurationRequest

        if (blockPublicAccessConfiguration != other.blockPublicAccessConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.PutBlockPublicAccessConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using `PermittedPublicSecurityGroupRuleRanges` in the `BlockPublicAccessConfiguration`. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating `BlockPublicSecurityGroupRules` to remove the exception.
         *
         * For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an Amazon EMR cluster in a Region before this date, block public access is enabled by default in that Region.
         */
        public var blockPublicAccessConfiguration: aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.PutBlockPublicAccessConfigurationRequest) : this() {
            this.blockPublicAccessConfiguration = x.blockPublicAccessConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.PutBlockPublicAccessConfigurationRequest = PutBlockPublicAccessConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration] inside the given [block]
         */
        public fun blockPublicAccessConfiguration(block: aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.blockPublicAccessConfiguration = aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
