// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
 */
public class OnDemandCapacityReservationOptions private constructor(builder: Builder) {
    /**
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * + `open` - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
     * + `none` - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.
     */
    public val capacityReservationPreference: aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationPreference? = builder.capacityReservationPreference
    /**
     * The ARN of the Capacity Reservation resource group in which to run the instance.
     */
    public val capacityReservationResourceGroupArn: kotlin.String? = builder.capacityReservationResourceGroupArn
    /**
     * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
     *
     * If you specify `use-capacity-reservations-first`, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (`lowest-price`) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (`lowest-price`).
     *
     * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.
     */
    public val usageStrategy: aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationUsageStrategy? = builder.usageStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OnDemandCapacityReservationOptions(")
        append("capacityReservationPreference=$capacityReservationPreference,")
        append("capacityReservationResourceGroupArn=$capacityReservationResourceGroupArn,")
        append("usageStrategy=$usageStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationPreference?.hashCode() ?: 0
        result = 31 * result + (capacityReservationResourceGroupArn?.hashCode() ?: 0)
        result = 31 * result + (usageStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OnDemandCapacityReservationOptions

        if (capacityReservationPreference != other.capacityReservationPreference) return false
        if (capacityReservationResourceGroupArn != other.capacityReservationResourceGroupArn) return false
        if (usageStrategy != other.usageStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * + `open` - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * + `none` - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.
         */
        public var capacityReservationPreference: aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationPreference? = null
        /**
         * The ARN of the Capacity Reservation resource group in which to run the instance.
         */
        public var capacityReservationResourceGroupArn: kotlin.String? = null
        /**
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         *
         * If you specify `use-capacity-reservations-first`, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (`lowest-price`) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (`lowest-price`).
         *
         * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.
         */
        public var usageStrategy: aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationUsageStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationOptions) : this() {
            this.capacityReservationPreference = x.capacityReservationPreference
            this.capacityReservationResourceGroupArn = x.capacityReservationResourceGroupArn
            this.usageStrategy = x.usageStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.OnDemandCapacityReservationOptions = OnDemandCapacityReservationOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
