// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A notebook execution. An execution is a specific instance that an Amazon EMR Notebook is run using the `StartNotebookExecution` action.
 */
public class NotebookExecution private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the notebook execution.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier of the Amazon EMR Notebook that is used for the notebook execution.
     */
    public val editorId: kotlin.String? = builder.editorId
    /**
     * The timestamp when notebook execution ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The environment variables associated with the notebook execution.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The execution engine, such as an Amazon EMR cluster, used to run the Amazon EMR notebook and perform the notebook execution.
     */
    public val executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = builder.executionEngine
    /**
     * The reason for the latest status change of the notebook execution.
     */
    public val lastStateChangeReason: kotlin.String? = builder.lastStateChangeReason
    /**
     * The unique identifier of a notebook execution.
     */
    public val notebookExecutionId: kotlin.String? = builder.notebookExecutionId
    /**
     * A name for the notebook execution.
     */
    public val notebookExecutionName: kotlin.String? = builder.notebookExecutionName
    /**
     * The unique identifier of the Amazon EC2 security group associated with the Amazon EMR Notebook instance. For more information see [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html) in the *Amazon EMR Management Guide*.
     */
    public val notebookInstanceSecurityGroupId: kotlin.String? = builder.notebookInstanceSecurityGroupId
    /**
     * Input parameters in JSON format passed to the Amazon EMR Notebook at runtime for execution.
     */
    public val notebookParams: kotlin.String? = builder.notebookParams
    /**
     * The Amazon S3 location that stores the notebook execution input.
     */
    public val notebookS3Location: aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput? = builder.notebookS3Location
    /**
     * The output format for the notebook execution.
     */
    public val outputNotebookFormat: aws.sdk.kotlin.services.emr.model.OutputNotebookFormat? = builder.outputNotebookFormat
    /**
     * The Amazon S3 location for the notebook execution output.
     */
    public val outputNotebookS3Location: aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationForOutput? = builder.outputNotebookS3Location
    /**
     * The location of the notebook execution's output file in Amazon S3.
     */
    public val outputNotebookUri: kotlin.String? = builder.outputNotebookUri
    /**
     * The timestamp when notebook execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the notebook execution.
     * + `START_PENDING` indicates that the cluster has received the execution request but execution has not begun.
     * + `STARTING` indicates that the execution is starting on the cluster.
     * + `RUNNING` indicates that the execution is being processed by the cluster.
     * + `FINISHING` indicates that execution processing is in the final stages.
     * + `FINISHED` indicates that the execution has completed without error.
     * + `FAILING` indicates that the execution is failing and will not finish successfully.
     * + `FAILED` indicates that the execution failed.
     * + `STOP_PENDING` indicates that the cluster has received a `StopNotebookExecution` request and the stop is pending.
     * + `STOPPING` indicates that the cluster is in the process of stopping the execution as a result of a `StopNotebookExecution` request.
     * + `STOPPED` indicates that the execution stopped because of a `StopNotebookExecution` request.
     */
    public val status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = builder.status
    /**
     * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.NotebookExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotebookExecution(")
        append("arn=$arn,")
        append("editorId=$editorId,")
        append("endTime=$endTime,")
        append("environmentVariables=$environmentVariables,")
        append("executionEngine=$executionEngine,")
        append("lastStateChangeReason=$lastStateChangeReason,")
        append("notebookExecutionId=$notebookExecutionId,")
        append("notebookExecutionName=$notebookExecutionName,")
        append("notebookInstanceSecurityGroupId=$notebookInstanceSecurityGroupId,")
        append("notebookParams=$notebookParams,")
        append("notebookS3Location=$notebookS3Location,")
        append("outputNotebookFormat=$outputNotebookFormat,")
        append("outputNotebookS3Location=$outputNotebookS3Location,")
        append("outputNotebookUri=$outputNotebookUri,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (editorId?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (executionEngine?.hashCode() ?: 0)
        result = 31 * result + (lastStateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionId?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (notebookParams?.hashCode() ?: 0)
        result = 31 * result + (notebookS3Location?.hashCode() ?: 0)
        result = 31 * result + (outputNotebookFormat?.hashCode() ?: 0)
        result = 31 * result + (outputNotebookS3Location?.hashCode() ?: 0)
        result = 31 * result + (outputNotebookUri?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotebookExecution

        if (arn != other.arn) return false
        if (editorId != other.editorId) return false
        if (endTime != other.endTime) return false
        if (environmentVariables != other.environmentVariables) return false
        if (executionEngine != other.executionEngine) return false
        if (lastStateChangeReason != other.lastStateChangeReason) return false
        if (notebookExecutionId != other.notebookExecutionId) return false
        if (notebookExecutionName != other.notebookExecutionName) return false
        if (notebookInstanceSecurityGroupId != other.notebookInstanceSecurityGroupId) return false
        if (notebookParams != other.notebookParams) return false
        if (notebookS3Location != other.notebookS3Location) return false
        if (outputNotebookFormat != other.outputNotebookFormat) return false
        if (outputNotebookS3Location != other.outputNotebookS3Location) return false
        if (outputNotebookUri != other.outputNotebookUri) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.NotebookExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the notebook execution.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier of the Amazon EMR Notebook that is used for the notebook execution.
         */
        public var editorId: kotlin.String? = null
        /**
         * The timestamp when notebook execution ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment variables associated with the notebook execution.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The execution engine, such as an Amazon EMR cluster, used to run the Amazon EMR notebook and perform the notebook execution.
         */
        public var executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = null
        /**
         * The reason for the latest status change of the notebook execution.
         */
        public var lastStateChangeReason: kotlin.String? = null
        /**
         * The unique identifier of a notebook execution.
         */
        public var notebookExecutionId: kotlin.String? = null
        /**
         * A name for the notebook execution.
         */
        public var notebookExecutionName: kotlin.String? = null
        /**
         * The unique identifier of the Amazon EC2 security group associated with the Amazon EMR Notebook instance. For more information see [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html) in the *Amazon EMR Management Guide*.
         */
        public var notebookInstanceSecurityGroupId: kotlin.String? = null
        /**
         * Input parameters in JSON format passed to the Amazon EMR Notebook at runtime for execution.
         */
        public var notebookParams: kotlin.String? = null
        /**
         * The Amazon S3 location that stores the notebook execution input.
         */
        public var notebookS3Location: aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput? = null
        /**
         * The output format for the notebook execution.
         */
        public var outputNotebookFormat: aws.sdk.kotlin.services.emr.model.OutputNotebookFormat? = null
        /**
         * The Amazon S3 location for the notebook execution output.
         */
        public var outputNotebookS3Location: aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationForOutput? = null
        /**
         * The location of the notebook execution's output file in Amazon S3.
         */
        public var outputNotebookUri: kotlin.String? = null
        /**
         * The timestamp when notebook execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the notebook execution.
         * + `START_PENDING` indicates that the cluster has received the execution request but execution has not begun.
         * + `STARTING` indicates that the execution is starting on the cluster.
         * + `RUNNING` indicates that the execution is being processed by the cluster.
         * + `FINISHING` indicates that execution processing is in the final stages.
         * + `FINISHED` indicates that the execution has completed without error.
         * + `FAILING` indicates that the execution is failing and will not finish successfully.
         * + `FAILED` indicates that the execution failed.
         * + `STOP_PENDING` indicates that the cluster has received a `StopNotebookExecution` request and the stop is pending.
         * + `STOPPING` indicates that the cluster is in the process of stopping the execution as a result of a `StopNotebookExecution` request.
         * + `STOPPED` indicates that the execution stopped because of a `StopNotebookExecution` request.
         */
        public var status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = null
        /**
         * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.NotebookExecution) : this() {
            this.arn = x.arn
            this.editorId = x.editorId
            this.endTime = x.endTime
            this.environmentVariables = x.environmentVariables
            this.executionEngine = x.executionEngine
            this.lastStateChangeReason = x.lastStateChangeReason
            this.notebookExecutionId = x.notebookExecutionId
            this.notebookExecutionName = x.notebookExecutionName
            this.notebookInstanceSecurityGroupId = x.notebookInstanceSecurityGroupId
            this.notebookParams = x.notebookParams
            this.notebookS3Location = x.notebookS3Location
            this.outputNotebookFormat = x.outputNotebookFormat
            this.outputNotebookS3Location = x.outputNotebookS3Location
            this.outputNotebookUri = x.outputNotebookUri
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.NotebookExecution = NotebookExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig] inside the given [block]
         */
        public fun executionEngine(block: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.Builder.() -> kotlin.Unit) {
            this.executionEngine = aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput] inside the given [block]
         */
        public fun notebookS3Location(block: aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput.Builder.() -> kotlin.Unit) {
            this.notebookS3Location = aws.sdk.kotlin.services.emr.model.NotebookS3LocationForOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationForOutput] inside the given [block]
         */
        public fun outputNotebookS3Location(block: aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationForOutput.Builder.() -> kotlin.Unit) {
            this.outputNotebookS3Location = aws.sdk.kotlin.services.emr.model.OutputNotebookS3LocationForOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
