// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * This entity represents an instance group, which is a group of instances that have common purpose. For example, CORE instance group is used for HDFS.
 */
public class InstanceGroup private constructor(builder: Builder) {
    /**
     * An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates Amazon EC2 instances in response to the value of a CloudWatch metric. See PutAutoScalingPolicy.
     */
    public val autoScalingPolicy: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription? = builder.autoScalingPolicy
    /**
     * If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify `OnDemandPrice` to set the amount equal to the On-Demand price, or specify an amount in USD.
     */
    public val bidPrice: kotlin.String? = builder.bidPrice
    /**
     * Amazon EMR releases 4.x or later.
     *
     * The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
     */
    public val configurations: List<Configuration>? = builder.configurations
    /**
     * The version number of the requested configuration specification for this instance group.
     */
    public val configurationsVersion: kotlin.Long? = builder.configurationsVersion
    /**
     * The custom AMI ID to use for the provisioned instance group.
     */
    public val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The EBS block devices that are mapped to this instance group.
     */
    public val ebsBlockDevices: List<EbsBlockDevice>? = builder.ebsBlockDevices
    /**
     * If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses an optimized configuration stack and provides additional, dedicated capacity for Amazon EBS I/O.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The identifier of the instance group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The type of the instance group. Valid values are MASTER, CORE or TASK.
     */
    public val instanceGroupType: aws.sdk.kotlin.services.emr.model.InstanceGroupType? = builder.instanceGroupType
    /**
     * The Amazon EC2 instance type for all instances in the instance group.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * A list of configurations that were successfully applied for an instance group last time.
     */
    public val lastSuccessfullyAppliedConfigurations: List<Configuration>? = builder.lastSuccessfullyAppliedConfigurations
    /**
     * The version number of a configuration specification that was successfully applied for an instance group last time.
     */
    public val lastSuccessfullyAppliedConfigurationsVersion: kotlin.Long? = builder.lastSuccessfullyAppliedConfigurationsVersion
    /**
     * The marketplace to provision instances for this group. Valid values are ON_DEMAND or SPOT.
     */
    public val market: aws.sdk.kotlin.services.emr.model.MarketType? = builder.market
    /**
     * The name of the instance group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The target number of instances for the instance group.
     */
    public val requestedInstanceCount: kotlin.Int? = builder.requestedInstanceCount
    /**
     * The number of instances currently running in this instance group.
     */
    public val runningInstanceCount: kotlin.Int? = builder.runningInstanceCount
    /**
     * Policy for customizing shrink operations.
     */
    public val shrinkPolicy: aws.sdk.kotlin.services.emr.model.ShrinkPolicy? = builder.shrinkPolicy
    /**
     * The current status of the instance group.
     */
    public val status: aws.sdk.kotlin.services.emr.model.InstanceGroupStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceGroup(")
        append("autoScalingPolicy=$autoScalingPolicy,")
        append("bidPrice=$bidPrice,")
        append("configurations=$configurations,")
        append("configurationsVersion=$configurationsVersion,")
        append("customAmiId=$customAmiId,")
        append("ebsBlockDevices=$ebsBlockDevices,")
        append("ebsOptimized=$ebsOptimized,")
        append("id=$id,")
        append("instanceGroupType=$instanceGroupType,")
        append("instanceType=$instanceType,")
        append("lastSuccessfullyAppliedConfigurations=$lastSuccessfullyAppliedConfigurations,")
        append("lastSuccessfullyAppliedConfigurationsVersion=$lastSuccessfullyAppliedConfigurationsVersion,")
        append("market=$market,")
        append("name=$name,")
        append("requestedInstanceCount=$requestedInstanceCount,")
        append("runningInstanceCount=$runningInstanceCount,")
        append("shrinkPolicy=$shrinkPolicy,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingPolicy?.hashCode() ?: 0
        result = 31 * result + (bidPrice?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (configurationsVersion?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsBlockDevices?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceGroupType?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfullyAppliedConfigurations?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfullyAppliedConfigurationsVersion?.hashCode() ?: 0)
        result = 31 * result + (market?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestedInstanceCount ?: 0)
        result = 31 * result + (runningInstanceCount ?: 0)
        result = 31 * result + (shrinkPolicy?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceGroup

        if (autoScalingPolicy != other.autoScalingPolicy) return false
        if (bidPrice != other.bidPrice) return false
        if (configurations != other.configurations) return false
        if (configurationsVersion != other.configurationsVersion) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsBlockDevices != other.ebsBlockDevices) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (id != other.id) return false
        if (instanceGroupType != other.instanceGroupType) return false
        if (instanceType != other.instanceType) return false
        if (lastSuccessfullyAppliedConfigurations != other.lastSuccessfullyAppliedConfigurations) return false
        if (lastSuccessfullyAppliedConfigurationsVersion != other.lastSuccessfullyAppliedConfigurationsVersion) return false
        if (market != other.market) return false
        if (name != other.name) return false
        if (requestedInstanceCount != other.requestedInstanceCount) return false
        if (runningInstanceCount != other.runningInstanceCount) return false
        if (shrinkPolicy != other.shrinkPolicy) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates Amazon EC2 instances in response to the value of a CloudWatch metric. See PutAutoScalingPolicy.
         */
        public var autoScalingPolicy: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription? = null
        /**
         * If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify `OnDemandPrice` to set the amount equal to the On-Demand price, or specify an amount in USD.
         */
        public var bidPrice: kotlin.String? = null
        /**
         * Amazon EMR releases 4.x or later.
         *
         * The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
         */
        public var configurations: List<Configuration>? = null
        /**
         * The version number of the requested configuration specification for this instance group.
         */
        public var configurationsVersion: kotlin.Long? = null
        /**
         * The custom AMI ID to use for the provisioned instance group.
         */
        public var customAmiId: kotlin.String? = null
        /**
         * The EBS block devices that are mapped to this instance group.
         */
        public var ebsBlockDevices: List<EbsBlockDevice>? = null
        /**
         * If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses an optimized configuration stack and provides additional, dedicated capacity for Amazon EBS I/O.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The identifier of the instance group.
         */
        public var id: kotlin.String? = null
        /**
         * The type of the instance group. Valid values are MASTER, CORE or TASK.
         */
        public var instanceGroupType: aws.sdk.kotlin.services.emr.model.InstanceGroupType? = null
        /**
         * The Amazon EC2 instance type for all instances in the instance group.
         */
        public var instanceType: kotlin.String? = null
        /**
         * A list of configurations that were successfully applied for an instance group last time.
         */
        public var lastSuccessfullyAppliedConfigurations: List<Configuration>? = null
        /**
         * The version number of a configuration specification that was successfully applied for an instance group last time.
         */
        public var lastSuccessfullyAppliedConfigurationsVersion: kotlin.Long? = null
        /**
         * The marketplace to provision instances for this group. Valid values are ON_DEMAND or SPOT.
         */
        public var market: aws.sdk.kotlin.services.emr.model.MarketType? = null
        /**
         * The name of the instance group.
         */
        public var name: kotlin.String? = null
        /**
         * The target number of instances for the instance group.
         */
        public var requestedInstanceCount: kotlin.Int? = null
        /**
         * The number of instances currently running in this instance group.
         */
        public var runningInstanceCount: kotlin.Int? = null
        /**
         * Policy for customizing shrink operations.
         */
        public var shrinkPolicy: aws.sdk.kotlin.services.emr.model.ShrinkPolicy? = null
        /**
         * The current status of the instance group.
         */
        public var status: aws.sdk.kotlin.services.emr.model.InstanceGroupStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceGroup) : this() {
            this.autoScalingPolicy = x.autoScalingPolicy
            this.bidPrice = x.bidPrice
            this.configurations = x.configurations
            this.configurationsVersion = x.configurationsVersion
            this.customAmiId = x.customAmiId
            this.ebsBlockDevices = x.ebsBlockDevices
            this.ebsOptimized = x.ebsOptimized
            this.id = x.id
            this.instanceGroupType = x.instanceGroupType
            this.instanceType = x.instanceType
            this.lastSuccessfullyAppliedConfigurations = x.lastSuccessfullyAppliedConfigurations
            this.lastSuccessfullyAppliedConfigurationsVersion = x.lastSuccessfullyAppliedConfigurationsVersion
            this.market = x.market
            this.name = x.name
            this.requestedInstanceCount = x.requestedInstanceCount
            this.runningInstanceCount = x.runningInstanceCount
            this.shrinkPolicy = x.shrinkPolicy
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceGroup = InstanceGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription] inside the given [block]
         */
        public fun autoScalingPolicy(block: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription.Builder.() -> kotlin.Unit) {
            this.autoScalingPolicy = aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ShrinkPolicy] inside the given [block]
         */
        public fun shrinkPolicy(block: aws.sdk.kotlin.services.emr.model.ShrinkPolicy.Builder.() -> kotlin.Unit) {
            this.shrinkPolicy = aws.sdk.kotlin.services.emr.model.ShrinkPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceGroupStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.emr.model.InstanceGroupStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.InstanceGroupStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
