// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * A job flow step consisting of a JAR file whose main function will be executed. The main function submits a job for Hadoop to execute and waits for the job to finish or fail.
 */
public class HadoopJarStepConfig private constructor(builder: Builder) {
    /**
     * A list of command line arguments passed to the JAR file's main function when executed.
     */
    public val args: List<String>? = builder.args
    /**
     * A path to a JAR file run during the step.
     */
    public val jar: kotlin.String? = builder.jar
    /**
     * The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
     */
    public val mainClass: kotlin.String? = builder.mainClass
    /**
     * A list of Java properties that are set when the step runs. You can use these properties to pass key-value pairs to your main function.
     */
    public val properties: List<KeyValue>? = builder.properties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HadoopJarStepConfig(")
        append("args=$args,")
        append("jar=$jar,")
        append("mainClass=$mainClass,")
        append("properties=$properties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = args?.hashCode() ?: 0
        result = 31 * result + (jar?.hashCode() ?: 0)
        result = 31 * result + (mainClass?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HadoopJarStepConfig

        if (args != other.args) return false
        if (jar != other.jar) return false
        if (mainClass != other.mainClass) return false
        if (properties != other.properties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of command line arguments passed to the JAR file's main function when executed.
         */
        public var args: List<String>? = null
        /**
         * A path to a JAR file run during the step.
         */
        public var jar: kotlin.String? = null
        /**
         * The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
         */
        public var mainClass: kotlin.String? = null
        /**
         * A list of Java properties that are set when the step runs. You can use these properties to pass key-value pairs to your main function.
         */
        public var properties: List<KeyValue>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig) : this() {
            this.args = x.args
            this.jar = x.jar
            this.mainClass = x.mainClass
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.HadoopJarStepConfig = HadoopJarStepConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
