// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.transform

import aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription
import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.PutAutoScalingPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutAutoScalingPolicyOperationDeserializer: HttpDeserialize<PutAutoScalingPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutAutoScalingPolicyResponse {
        if (!response.status.isSuccess()) {
            throwPutAutoScalingPolicyError(context, response)
        }
        val builder = PutAutoScalingPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutAutoScalingPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutAutoScalingPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutAutoScalingPolicyOperationBody(builder: PutAutoScalingPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOSCALINGPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoScalingPolicy"))
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterArn"))
    val CLUSTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterId"))
    val INSTANCEGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceGroupId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOSCALINGPOLICY_DESCRIPTOR)
        field(CLUSTERARN_DESCRIPTOR)
        field(CLUSTERID_DESCRIPTOR)
        field(INSTANCEGROUPID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOSCALINGPOLICY_DESCRIPTOR.index -> builder.autoScalingPolicy = deserializeAutoScalingPolicyDescriptionDocument(deserializer)
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                CLUSTERID_DESCRIPTOR.index -> builder.clusterId = deserializeString()
                INSTANCEGROUPID_DESCRIPTOR.index -> builder.instanceGroupId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
