// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.transform

import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.GetStudioSessionMappingResponse
import aws.sdk.kotlin.services.emr.model.SessionMappingDetail
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetStudioSessionMappingOperationDeserializer: HttpDeserialize<GetStudioSessionMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetStudioSessionMappingResponse {
        if (!response.status.isSuccess()) {
            throwGetStudioSessionMappingError(context, response)
        }
        val builder = GetStudioSessionMappingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetStudioSessionMappingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetStudioSessionMappingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetStudioSessionMappingOperationBody(builder: GetStudioSessionMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SESSIONMAPPING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SessionMapping"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SESSIONMAPPING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SESSIONMAPPING_DESCRIPTOR.index -> builder.sessionMapping = deserializeSessionMappingDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
