// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for an Amazon EMR Studio including ID, creation time, name, and so on.
 */
public class Studio private constructor(builder: Builder) {
    /**
     * Specifies whether the Amazon EMR Studio authenticates users using IAM or IAM Identity Center.
     */
    public val authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = builder.authMode
    /**
     * The time the Amazon EMR Studio was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    public val defaultS3Location: kotlin.String? = builder.defaultS3Location
    /**
     * The detailed description of the Amazon EMR Studio.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group allows inbound network traffic from resources in the Workspace security group.
     */
    public val engineSecurityGroupId: kotlin.String? = builder.engineSecurityGroupId
    /**
     * Your identity provider's authentication endpoint. Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.
     */
    public val idpAuthUrl: kotlin.String? = builder.idpAuthUrl
    /**
     * The name of your identity provider's `RelayState` parameter.
     */
    public val idpRelayStateParameterName: kotlin.String? = builder.idpRelayStateParameterName
    /**
     * The name of the Amazon EMR Studio.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the IAM role assumed by the Amazon EMR Studio.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The Amazon Resource Name (ARN) of the Amazon EMR Studio.
     */
    public val studioArn: kotlin.String? = builder.studioArn
    /**
     * The ID of the Amazon EMR Studio.
     */
    public val studioId: kotlin.String? = builder.studioId
    /**
     * The list of IDs of the subnets associated with the Amazon EMR Studio.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of tags associated with the Amazon EMR Studio.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The unique access URL of the Amazon EMR Studio.
     */
    public val url: kotlin.String? = builder.url
    /**
     * The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A Studio only requires a `UserRole` when you use IAM authentication.
     */
    public val userRole: kotlin.String? = builder.userRole
    /**
     * The ID of the VPC associated with the Amazon EMR Studio.
     */
    public val vpcId: kotlin.String? = builder.vpcId
    /**
     * The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security group allows outbound network traffic to resources in the Engine security group and to the internet.
     */
    public val workspaceSecurityGroupId: kotlin.String? = builder.workspaceSecurityGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Studio = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Studio(")
        append("authMode=$authMode,")
        append("creationTime=$creationTime,")
        append("defaultS3Location=$defaultS3Location,")
        append("description=$description,")
        append("engineSecurityGroupId=$engineSecurityGroupId,")
        append("idpAuthUrl=$idpAuthUrl,")
        append("idpRelayStateParameterName=$idpRelayStateParameterName,")
        append("name=$name,")
        append("serviceRole=$serviceRole,")
        append("studioArn=$studioArn,")
        append("studioId=$studioId,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("url=$url,")
        append("userRole=$userRole,")
        append("vpcId=$vpcId,")
        append("workspaceSecurityGroupId=$workspaceSecurityGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authMode?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (defaultS3Location?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (idpAuthUrl?.hashCode() ?: 0)
        result = 31 * result + (idpRelayStateParameterName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (studioArn?.hashCode() ?: 0)
        result = 31 * result + (studioId?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (userRole?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (workspaceSecurityGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Studio

        if (authMode != other.authMode) return false
        if (creationTime != other.creationTime) return false
        if (defaultS3Location != other.defaultS3Location) return false
        if (description != other.description) return false
        if (engineSecurityGroupId != other.engineSecurityGroupId) return false
        if (idpAuthUrl != other.idpAuthUrl) return false
        if (idpRelayStateParameterName != other.idpRelayStateParameterName) return false
        if (name != other.name) return false
        if (serviceRole != other.serviceRole) return false
        if (studioArn != other.studioArn) return false
        if (studioId != other.studioId) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (url != other.url) return false
        if (userRole != other.userRole) return false
        if (vpcId != other.vpcId) return false
        if (workspaceSecurityGroupId != other.workspaceSecurityGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Studio = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the Amazon EMR Studio authenticates users using IAM or IAM Identity Center.
         */
        public var authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = null
        /**
         * The time the Amazon EMR Studio was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         */
        public var defaultS3Location: kotlin.String? = null
        /**
         * The detailed description of the Amazon EMR Studio.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group allows inbound network traffic from resources in the Workspace security group.
         */
        public var engineSecurityGroupId: kotlin.String? = null
        /**
         * Your identity provider's authentication endpoint. Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.
         */
        public var idpAuthUrl: kotlin.String? = null
        /**
         * The name of your identity provider's `RelayState` parameter.
         */
        public var idpRelayStateParameterName: kotlin.String? = null
        /**
         * The name of the Amazon EMR Studio.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the IAM role assumed by the Amazon EMR Studio.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon EMR Studio.
         */
        public var studioArn: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio.
         */
        public var studioId: kotlin.String? = null
        /**
         * The list of IDs of the subnets associated with the Amazon EMR Studio.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of tags associated with the Amazon EMR Studio.
         */
        public var tags: List<Tag>? = null
        /**
         * The unique access URL of the Amazon EMR Studio.
         */
        public var url: kotlin.String? = null
        /**
         * The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A Studio only requires a `UserRole` when you use IAM authentication.
         */
        public var userRole: kotlin.String? = null
        /**
         * The ID of the VPC associated with the Amazon EMR Studio.
         */
        public var vpcId: kotlin.String? = null
        /**
         * The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security group allows outbound network traffic to resources in the Engine security group and to the internet.
         */
        public var workspaceSecurityGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Studio) : this() {
            this.authMode = x.authMode
            this.creationTime = x.creationTime
            this.defaultS3Location = x.defaultS3Location
            this.description = x.description
            this.engineSecurityGroupId = x.engineSecurityGroupId
            this.idpAuthUrl = x.idpAuthUrl
            this.idpRelayStateParameterName = x.idpRelayStateParameterName
            this.name = x.name
            this.serviceRole = x.serviceRole
            this.studioArn = x.studioArn
            this.studioId = x.studioId
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.url = x.url
            this.userRole = x.userRole
            this.vpcId = x.vpcId
            this.workspaceSecurityGroupId = x.workspaceSecurityGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Studio = Studio(this)
    }
}
