// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * An automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period, and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
 */
public class SimpleScalingPolicyConfiguration private constructor(builder: Builder) {
    /**
     * The way in which EC2 instances are added (if `ScalingAdjustment` is a positive number) or terminated (if `ScalingAdjustment` is a negative number) each time the scaling activity is triggered. `CHANGE_IN_CAPACITY` is the default. `CHANGE_IN_CAPACITY` indicates that the EC2 instance count increments or decrements by `ScalingAdjustment`, which should be expressed as an integer. `PERCENT_CHANGE_IN_CAPACITY` indicates the instance count increments or decrements by the percentage specified by `ScalingAdjustment`, which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. `EXACT_CAPACITY` indicates the scaling activity results in an instance group with the number of EC2 instances specified by `ScalingAdjustment`, which should be expressed as a positive integer.
     */
    public val adjustmentType: aws.sdk.kotlin.services.emr.model.AdjustmentType? = builder.adjustmentType
    /**
     * The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start. The default value is 0.
     */
    public val coolDown: kotlin.Int? = builder.coolDown
    /**
     * The amount by which to scale in or scale out, based on the specified `AdjustmentType`. A positive value adds to the instance group's EC2 instance count while a negative number removes instances. If `AdjustmentType` is set to `EXACT_CAPACITY`, the number should only be a positive integer. If `AdjustmentType` is set to `PERCENT_CHANGE_IN_CAPACITY`, the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.
     */
    public val scalingAdjustment: kotlin.Int? = builder.scalingAdjustment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.SimpleScalingPolicyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimpleScalingPolicyConfiguration(")
        append("adjustmentType=$adjustmentType,")
        append("coolDown=$coolDown,")
        append("scalingAdjustment=$scalingAdjustment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustmentType?.hashCode() ?: 0
        result = 31 * result + (coolDown ?: 0)
        result = 31 * result + (scalingAdjustment ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimpleScalingPolicyConfiguration

        if (adjustmentType != other.adjustmentType) return false
        if (coolDown != other.coolDown) return false
        if (scalingAdjustment != other.scalingAdjustment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.SimpleScalingPolicyConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The way in which EC2 instances are added (if `ScalingAdjustment` is a positive number) or terminated (if `ScalingAdjustment` is a negative number) each time the scaling activity is triggered. `CHANGE_IN_CAPACITY` is the default. `CHANGE_IN_CAPACITY` indicates that the EC2 instance count increments or decrements by `ScalingAdjustment`, which should be expressed as an integer. `PERCENT_CHANGE_IN_CAPACITY` indicates the instance count increments or decrements by the percentage specified by `ScalingAdjustment`, which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. `EXACT_CAPACITY` indicates the scaling activity results in an instance group with the number of EC2 instances specified by `ScalingAdjustment`, which should be expressed as a positive integer.
         */
        public var adjustmentType: aws.sdk.kotlin.services.emr.model.AdjustmentType? = null
        /**
         * The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start. The default value is 0.
         */
        public var coolDown: kotlin.Int? = null
        /**
         * The amount by which to scale in or scale out, based on the specified `AdjustmentType`. A positive value adds to the instance group's EC2 instance count while a negative number removes instances. If `AdjustmentType` is set to `EXACT_CAPACITY`, the number should only be a positive integer. If `AdjustmentType` is set to `PERCENT_CHANGE_IN_CAPACITY`, the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.
         */
        public var scalingAdjustment: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.SimpleScalingPolicyConfiguration) : this() {
            this.adjustmentType = x.adjustmentType
            this.coolDown = x.coolDown
            this.scalingAdjustment = x.scalingAdjustment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.SimpleScalingPolicyConfiguration = SimpleScalingPolicyConfiguration(this)
    }
}
