// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Input to the RunJobFlow operation.
 */
public class RunJobFlowRequest private constructor(builder: Builder) {
    /**
     * A JSON string for selecting additional features.
     */
    public val additionalInfo: kotlin.String? = builder.additionalInfo
    /**
     * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, `ReleaseLabel` is used. To specify a custom AMI, use `CustomAmiID`.
     */
    public val amiVersion: kotlin.String? = builder.amiVersion
    /**
     * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMRRelease Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/).
     */
    public val applications: List<Application>? = builder.applications
    /**
     * An IAM role for automatic scaling policies. The default role is `EMR_AutoScaling_DefaultRole`. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     */
    public val autoScalingRole: kotlin.String? = builder.autoScalingRole
    /**
     * An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see [Control cluster termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html).
     */
    public val autoTerminationPolicy: aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy? = builder.autoTerminationPolicy
    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     */
    public val bootstrapActions: List<BootstrapActionConfig>? = builder.bootstrapActions
    /**
     * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR cluster you are creating.
     */
    public val configurations: List<Configuration>? = builder.configurations
    /**
     * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2 instances. For more information about custom AMIs in Amazon EMR, see [Using a Custom AMI](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html) in the *Amazon EMR Management Guide*. If omitted, the cluster uses the base Linux AMI for the `ReleaseLabel` specified. For Amazon EMR versions 2.x and 3.x, use `AmiVersion` instead.
     *
     * For information about creating a custom AMI, see [Creating an Amazon EBS-Backed Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*. For information about finding an AMI ID, see [Finding a Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html).
     */
    public val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
     */
    public val ebsRootVolumeSize: kotlin.Int? = builder.ebsRootVolumeSize
    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    public val instances: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig? = builder.instances
    /**
     * Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is `EMR_EC2_DefaultRole`. In order to use the default role, you must have already created it using the CLI or console.
     */
    public val jobFlowRole: kotlin.String? = builder.jobFlowRole
    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see [Use Kerberos Authentication](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html) in the *Amazon EMR Management Guide*.
     */
    public val kerberosAttributes: aws.sdk.kotlin.services.emr.model.KerberosAttributes? = builder.kerberosAttributes
    /**
     * The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This attribute is only available with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.
     */
    public val logEncryptionKmsKeyId: kotlin.String? = builder.logEncryptionKmsKeyId
    /**
     * The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not created.
     */
    public val logUri: kotlin.String? = builder.logUri
    /**
     * The specified managed scaling policy for an Amazon EMR cluster.
     */
    public val managedScalingPolicy: aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy? = builder.managedScalingPolicy
    /**
     * The name of the job flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
     *
     * A list of strings that indicates third-party software to use with the job flow that accepts a user argument list. EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the [Amazon EMR Developer Guide](https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf). Supported values are:
     * + "mapr-m3" - launch the cluster using MapR M3 Edition.
     * + "mapr-m5" - launch the cluster using MapR M5 Edition.
     * + "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5 Edition respectively.
     * + "mapr-m7" - launch the cluster using MapR M7 Edition.
     * + "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
     * + "hue"- launch the cluster with Hue installed.
     * + "spark" - launch the cluster with Apache Spark installed.
     * + "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
     */
    public val newSupportedProducts: List<SupportedProductConfig>? = builder.newSupportedProducts
    /**
     * Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a release is not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
     */
    public val osReleaseLabel: kotlin.String? = builder.osReleaseLabel
    /**
     * The specified placement group configuration for an Amazon EMR cluster.
     */
    public val placementGroupConfigs: List<PlacementGroupConfig>? = builder.placementGroupConfigs
    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form `emr-x.x.x`, where x.x.x is an Amazon EMR release version such as `emr-5.14.0`. For more information about Amazon EMR release versions and included application versions and features, see [https://docs.aws.amazon.com/emr/latest/ReleaseGuide/](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/). The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use `AmiVersion`.
     */
    public val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * Applies only when `CustomAmiID` is used. Specifies which updates from the Amazon Linux AMI package repositories to apply automatically when the instance boots using the AMI. If omitted, the default is `SECURITY`, which indicates that only security updates are applied. If `NONE` is specified, no updates are applied, and all updates must be applied manually.
     */
    public val repoUpgradeOnBoot: aws.sdk.kotlin.services.emr.model.RepoUpgradeOnBoot? = builder.repoUpgradeOnBoot
    /**
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. `TERMINATE_AT_INSTANCE_HOUR` indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. `TERMINATE_AT_TASK_COMPLETION` indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. `TERMINATE_AT_TASK_COMPLETION` available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     */
    public val scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = builder.scaleDownBehavior
    /**
     * The name of a security configuration to apply to the cluster.
     */
    public val securityConfiguration: kotlin.String? = builder.securityConfiguration
    /**
     * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf. If you've created a custom service role path, you must specify it for the service role when you launch your cluster.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Specifies the number of steps that can be executed concurrently. The default value is `1`. The maximum value is `256`.
     */
    public val stepConcurrencyLevel: kotlin.Int? = builder.stepConcurrencyLevel
    /**
     * A list of steps to run.
     */
    public val steps: List<StepConfig>? = builder.steps
    /**
     * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
     *
     * A list of strings that indicates third-party software to use. For more information, see the [Amazon EMR Developer Guide](https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf). Currently supported values are:
     * + "mapr-m3" - launch the job flow using MapR M3 Edition.
     * + "mapr-m5" - launch the job flow using MapR M5 Edition.
     */
    public val supportedProducts: List<String>? = builder.supportedProducts
    /**
     * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The VisibleToAllUsers parameter is no longer supported. By default, the value is set to `true`. Setting it to `false` now has no effect.
     *
     * Set this value to `true` so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to `true` for clusters created using the EMR API or the CLI [create-cluster](https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html) command.
     *
     * When set to `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see [Understanding the EMR Cluster VisibleToAllUsers Setting](https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users) in the *Amazon EMRManagement Guide*.
     */
    public val visibleToAllUsers: kotlin.Boolean = builder.visibleToAllUsers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.RunJobFlowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunJobFlowRequest(")
        append("additionalInfo=$additionalInfo,")
        append("amiVersion=$amiVersion,")
        append("applications=$applications,")
        append("autoScalingRole=$autoScalingRole,")
        append("autoTerminationPolicy=$autoTerminationPolicy,")
        append("bootstrapActions=$bootstrapActions,")
        append("configurations=$configurations,")
        append("customAmiId=$customAmiId,")
        append("ebsRootVolumeSize=$ebsRootVolumeSize,")
        append("instances=$instances,")
        append("jobFlowRole=$jobFlowRole,")
        append("kerberosAttributes=$kerberosAttributes,")
        append("logEncryptionKmsKeyId=$logEncryptionKmsKeyId,")
        append("logUri=$logUri,")
        append("managedScalingPolicy=$managedScalingPolicy,")
        append("name=$name,")
        append("newSupportedProducts=$newSupportedProducts,")
        append("osReleaseLabel=$osReleaseLabel,")
        append("placementGroupConfigs=$placementGroupConfigs,")
        append("releaseLabel=$releaseLabel,")
        append("repoUpgradeOnBoot=$repoUpgradeOnBoot,")
        append("scaleDownBehavior=$scaleDownBehavior,")
        append("securityConfiguration=$securityConfiguration,")
        append("serviceRole=$serviceRole,")
        append("stepConcurrencyLevel=$stepConcurrencyLevel,")
        append("steps=$steps,")
        append("supportedProducts=$supportedProducts,")
        append("tags=$tags,")
        append("visibleToAllUsers=$visibleToAllUsers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (amiVersion?.hashCode() ?: 0)
        result = 31 * result + (applications?.hashCode() ?: 0)
        result = 31 * result + (autoScalingRole?.hashCode() ?: 0)
        result = 31 * result + (autoTerminationPolicy?.hashCode() ?: 0)
        result = 31 * result + (bootstrapActions?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsRootVolumeSize ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (jobFlowRole?.hashCode() ?: 0)
        result = 31 * result + (kerberosAttributes?.hashCode() ?: 0)
        result = 31 * result + (logEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (managedScalingPolicy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newSupportedProducts?.hashCode() ?: 0)
        result = 31 * result + (osReleaseLabel?.hashCode() ?: 0)
        result = 31 * result + (placementGroupConfigs?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (repoUpgradeOnBoot?.hashCode() ?: 0)
        result = 31 * result + (scaleDownBehavior?.hashCode() ?: 0)
        result = 31 * result + (securityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (stepConcurrencyLevel ?: 0)
        result = 31 * result + (steps?.hashCode() ?: 0)
        result = 31 * result + (supportedProducts?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (visibleToAllUsers.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunJobFlowRequest

        if (additionalInfo != other.additionalInfo) return false
        if (amiVersion != other.amiVersion) return false
        if (applications != other.applications) return false
        if (autoScalingRole != other.autoScalingRole) return false
        if (autoTerminationPolicy != other.autoTerminationPolicy) return false
        if (bootstrapActions != other.bootstrapActions) return false
        if (configurations != other.configurations) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsRootVolumeSize != other.ebsRootVolumeSize) return false
        if (instances != other.instances) return false
        if (jobFlowRole != other.jobFlowRole) return false
        if (kerberosAttributes != other.kerberosAttributes) return false
        if (logEncryptionKmsKeyId != other.logEncryptionKmsKeyId) return false
        if (logUri != other.logUri) return false
        if (managedScalingPolicy != other.managedScalingPolicy) return false
        if (name != other.name) return false
        if (newSupportedProducts != other.newSupportedProducts) return false
        if (osReleaseLabel != other.osReleaseLabel) return false
        if (placementGroupConfigs != other.placementGroupConfigs) return false
        if (releaseLabel != other.releaseLabel) return false
        if (repoUpgradeOnBoot != other.repoUpgradeOnBoot) return false
        if (scaleDownBehavior != other.scaleDownBehavior) return false
        if (securityConfiguration != other.securityConfiguration) return false
        if (serviceRole != other.serviceRole) return false
        if (stepConcurrencyLevel != other.stepConcurrencyLevel) return false
        if (steps != other.steps) return false
        if (supportedProducts != other.supportedProducts) return false
        if (tags != other.tags) return false
        if (visibleToAllUsers != other.visibleToAllUsers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.RunJobFlowRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A JSON string for selecting additional features.
         */
        public var additionalInfo: kotlin.String? = null
        /**
         * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, `ReleaseLabel` is used. To specify a custom AMI, use `CustomAmiID`.
         */
        public var amiVersion: kotlin.String? = null
        /**
         * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMRRelease Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/).
         */
        public var applications: List<Application>? = null
        /**
         * An IAM role for automatic scaling policies. The default role is `EMR_AutoScaling_DefaultRole`. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
         */
        public var autoScalingRole: kotlin.String? = null
        /**
         * An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see [Control cluster termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html).
         */
        public var autoTerminationPolicy: aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy? = null
        /**
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         */
        public var bootstrapActions: List<BootstrapActionConfig>? = null
        /**
         * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR cluster you are creating.
         */
        public var configurations: List<Configuration>? = null
        /**
         * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2 instances. For more information about custom AMIs in Amazon EMR, see [Using a Custom AMI](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html) in the *Amazon EMR Management Guide*. If omitted, the cluster uses the base Linux AMI for the `ReleaseLabel` specified. For Amazon EMR versions 2.x and 3.x, use `AmiVersion` instead.
         *
         * For information about creating a custom AMI, see [Creating an Amazon EBS-Backed Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*. For information about finding an AMI ID, see [Finding a Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html).
         */
        public var customAmiId: kotlin.String? = null
        /**
         * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
         */
        public var ebsRootVolumeSize: kotlin.Int? = null
        /**
         * A specification of the number and type of Amazon EC2 instances.
         */
        public var instances: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig? = null
        /**
         * Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is `EMR_EC2_DefaultRole`. In order to use the default role, you must have already created it using the CLI or console.
         */
        public var jobFlowRole: kotlin.String? = null
        /**
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see [Use Kerberos Authentication](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html) in the *Amazon EMR Management Guide*.
         */
        public var kerberosAttributes: aws.sdk.kotlin.services.emr.model.KerberosAttributes? = null
        /**
         * The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This attribute is only available with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.
         */
        public var logEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not created.
         */
        public var logUri: kotlin.String? = null
        /**
         * The specified managed scaling policy for an Amazon EMR cluster.
         */
        public var managedScalingPolicy: aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy? = null
        /**
         * The name of the job flow.
         */
        public var name: kotlin.String? = null
        /**
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         *
         * A list of strings that indicates third-party software to use with the job flow that accepts a user argument list. EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the [Amazon EMR Developer Guide](https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf). Supported values are:
         * + "mapr-m3" - launch the cluster using MapR M3 Edition.
         * + "mapr-m5" - launch the cluster using MapR M5 Edition.
         * + "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5 Edition respectively.
         * + "mapr-m7" - launch the cluster using MapR M7 Edition.
         * + "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         * + "hue"- launch the cluster with Hue installed.
         * + "spark" - launch the cluster with Apache Spark installed.
         * + "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
         */
        public var newSupportedProducts: List<SupportedProductConfig>? = null
        /**
         * Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a release is not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
         */
        public var osReleaseLabel: kotlin.String? = null
        /**
         * The specified placement group configuration for an Amazon EMR cluster.
         */
        public var placementGroupConfigs: List<PlacementGroupConfig>? = null
        /**
         * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form `emr-x.x.x`, where x.x.x is an Amazon EMR release version such as `emr-5.14.0`. For more information about Amazon EMR release versions and included application versions and features, see [https://docs.aws.amazon.com/emr/latest/ReleaseGuide/](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/). The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use `AmiVersion`.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * Applies only when `CustomAmiID` is used. Specifies which updates from the Amazon Linux AMI package repositories to apply automatically when the instance boots using the AMI. If omitted, the default is `SECURITY`, which indicates that only security updates are applied. If `NONE` is specified, no updates are applied, and all updates must be applied manually.
         */
        public var repoUpgradeOnBoot: aws.sdk.kotlin.services.emr.model.RepoUpgradeOnBoot? = null
        /**
         * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. `TERMINATE_AT_INSTANCE_HOUR` indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. `TERMINATE_AT_TASK_COMPLETION` indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. `TERMINATE_AT_TASK_COMPLETION` available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         */
        public var scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = null
        /**
         * The name of a security configuration to apply to the cluster.
         */
        public var securityConfiguration: kotlin.String? = null
        /**
         * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf. If you've created a custom service role path, you must specify it for the service role when you launch your cluster.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Specifies the number of steps that can be executed concurrently. The default value is `1`. The maximum value is `256`.
         */
        public var stepConcurrencyLevel: kotlin.Int? = null
        /**
         * A list of steps to run.
         */
        public var steps: List<StepConfig>? = null
        /**
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         *
         * A list of strings that indicates third-party software to use. For more information, see the [Amazon EMR Developer Guide](https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf). Currently supported values are:
         * + "mapr-m3" - launch the job flow using MapR M3 Edition.
         * + "mapr-m5" - launch the job flow using MapR M5 Edition.
         */
        public var supportedProducts: List<String>? = null
        /**
         * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         */
        public var tags: List<Tag>? = null
        /**
         * The VisibleToAllUsers parameter is no longer supported. By default, the value is set to `true`. Setting it to `false` now has no effect.
         *
         * Set this value to `true` so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to `true` for clusters created using the EMR API or the CLI [create-cluster](https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html) command.
         *
         * When set to `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see [Understanding the EMR Cluster VisibleToAllUsers Setting](https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users) in the *Amazon EMRManagement Guide*.
         */
        public var visibleToAllUsers: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.RunJobFlowRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.amiVersion = x.amiVersion
            this.applications = x.applications
            this.autoScalingRole = x.autoScalingRole
            this.autoTerminationPolicy = x.autoTerminationPolicy
            this.bootstrapActions = x.bootstrapActions
            this.configurations = x.configurations
            this.customAmiId = x.customAmiId
            this.ebsRootVolumeSize = x.ebsRootVolumeSize
            this.instances = x.instances
            this.jobFlowRole = x.jobFlowRole
            this.kerberosAttributes = x.kerberosAttributes
            this.logEncryptionKmsKeyId = x.logEncryptionKmsKeyId
            this.logUri = x.logUri
            this.managedScalingPolicy = x.managedScalingPolicy
            this.name = x.name
            this.newSupportedProducts = x.newSupportedProducts
            this.osReleaseLabel = x.osReleaseLabel
            this.placementGroupConfigs = x.placementGroupConfigs
            this.releaseLabel = x.releaseLabel
            this.repoUpgradeOnBoot = x.repoUpgradeOnBoot
            this.scaleDownBehavior = x.scaleDownBehavior
            this.securityConfiguration = x.securityConfiguration
            this.serviceRole = x.serviceRole
            this.stepConcurrencyLevel = x.stepConcurrencyLevel
            this.steps = x.steps
            this.supportedProducts = x.supportedProducts
            this.tags = x.tags
            this.visibleToAllUsers = x.visibleToAllUsers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.RunJobFlowRequest = RunJobFlowRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy] inside the given [block]
         */
        public fun autoTerminationPolicy(block: aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy.Builder.() -> kotlin.Unit) {
            this.autoTerminationPolicy = aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig] inside the given [block]
         */
        public fun instances(block: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig.Builder.() -> kotlin.Unit) {
            this.instances = aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.KerberosAttributes] inside the given [block]
         */
        public fun kerberosAttributes(block: aws.sdk.kotlin.services.emr.model.KerberosAttributes.Builder.() -> kotlin.Unit) {
            this.kerberosAttributes = aws.sdk.kotlin.services.emr.model.KerberosAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy] inside the given [block]
         */
        public fun managedScalingPolicy(block: aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy.Builder.() -> kotlin.Unit) {
            this.managedScalingPolicy = aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy.invoke(block)
        }
    }
}
