// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * The definition of a CloudWatch metric alarm, which determines when an automatic scaling activity is triggered. When the defined alarm conditions are satisfied, scaling activity begins.
 */
public class CloudWatchAlarmDefinition private constructor(builder: Builder) {
    /**
     * Determines how the metric specified by `MetricName` is compared to the value specified by `Threshold`.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.emr.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * A CloudWatch metric dimension.
     */
    public val dimensions: List<MetricDimension>? = builder.dimensions
    /**
     * The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity. The default value is `1`.
     */
    public val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * The name of the CloudWatch metric that is watched to determine an alarm condition.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * The namespace for the CloudWatch metric. The default is `AWS/ElasticMapReduce`.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The period, in seconds, over which the statistic is applied. EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified, specify `300`.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The statistic to apply to the metric associated with the alarm. The default is `AVERAGE`.
     */
    public val statistic: aws.sdk.kotlin.services.emr.model.Statistic? = builder.statistic
    /**
     * The value against which the specified statistic is compared.
     */
    public val threshold: kotlin.Double? = builder.threshold
    /**
     * The unit of measure associated with the CloudWatch metric being watched. The value specified for `Unit` must correspond to the units specified in the CloudWatch metric.
     */
    public val unit: aws.sdk.kotlin.services.emr.model.EmrUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.CloudWatchAlarmDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchAlarmDefinition(")
        append("comparisonOperator=$comparisonOperator,")
        append("dimensions=$dimensions,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("period=$period,")
        append("statistic=$statistic,")
        append("threshold=$threshold,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator?.hashCode() ?: 0
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchAlarmDefinition

        if (comparisonOperator != other.comparisonOperator) return false
        if (dimensions != other.dimensions) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (period != other.period) return false
        if (statistic != other.statistic) return false
        if (threshold != other.threshold) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.CloudWatchAlarmDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines how the metric specified by `MetricName` is compared to the value specified by `Threshold`.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.emr.model.ComparisonOperator? = null
        /**
         * A CloudWatch metric dimension.
         */
        public var dimensions: List<MetricDimension>? = null
        /**
         * The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity. The default value is `1`.
         */
        public var evaluationPeriods: kotlin.Int? = null
        /**
         * The name of the CloudWatch metric that is watched to determine an alarm condition.
         */
        public var metricName: kotlin.String? = null
        /**
         * The namespace for the CloudWatch metric. The default is `AWS/ElasticMapReduce`.
         */
        public var namespace: kotlin.String? = null
        /**
         * The period, in seconds, over which the statistic is applied. EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified, specify `300`.
         */
        public var period: kotlin.Int? = null
        /**
         * The statistic to apply to the metric associated with the alarm. The default is `AVERAGE`.
         */
        public var statistic: aws.sdk.kotlin.services.emr.model.Statistic? = null
        /**
         * The value against which the specified statistic is compared.
         */
        public var threshold: kotlin.Double? = null
        /**
         * The unit of measure associated with the CloudWatch metric being watched. The value specified for `Unit` must correspond to the units specified in the CloudWatch metric.
         */
        public var unit: aws.sdk.kotlin.services.emr.model.EmrUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.CloudWatchAlarmDefinition) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.dimensions = x.dimensions
            this.evaluationPeriods = x.evaluationPeriods
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.period = x.period
            this.statistic = x.statistic
            this.threshold = x.threshold
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.CloudWatchAlarmDefinition = CloudWatchAlarmDefinition(this)
    }
}
